"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.patch = patch;

var _ast = require("./ast");

var _compare = require("./compare");

var _to_expression = require("./to_expression");

/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
function patch(expression, ast) {
  let result = '';
  let position = 0;

  function apply(change) {
    if ((0, _compare.isValueChange)(change)) {
      return void patchValue(change);
    }

    throw new Error('Cannot apply patch for the change.');
  }

  function patchValue(change) {
    if ((0, _ast.isAstWithMeta)(change.source)) {
      throw new Error('Patching sub-expressions is not supported.');
    }

    result += `${expression.substring(position, change.source.start)}${(0, _to_expression.toExpression)(change.target, 'argument')}`;
    position = change.source.end;
  }

  (0, _compare.compare)(expression, ast).sort(({
    source: source1
  }, {
    source: source2
  }) => source1.start - source2.start).forEach(apply);
  result += expression.substring(position);
  return result;
}