import _toConsumableArray from "@babel/runtime/helpers/toConsumableArray";
import _slicedToArray from "@babel/runtime/helpers/slicedToArray";

/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
import { forEach, xor, zip } from 'lodash';
import { parse } from '../parse';
import { isAst, isAstWithMeta } from './ast';
export function isValueChange(value) {
  return (value === null || value === void 0 ? void 0 : value.type) === 'value';
}
export function compare(expression, ast) {
  var astWithMeta = parse(expression, {
    addMeta: true
  });
  var queue = [[astWithMeta, ast]];
  var changes = [];

  function compareExpression(source, target) {
    zip(source.node.chain, target.chain).forEach(function (_ref) {
      var _ref2 = _slicedToArray(_ref, 2),
          fnWithMeta = _ref2[0],
          fn = _ref2[1];

      if (!fnWithMeta || !fn || (fnWithMeta === null || fnWithMeta === void 0 ? void 0 : fnWithMeta.node["function"]) !== (fn === null || fn === void 0 ? void 0 : fn["function"])) {
        throw Error('Expression changes are not supported.');
      }

      compareFunction(fnWithMeta, fn);
    });
  }

  function compareFunction(source, target) {
    if (xor(Object.keys(source.node.arguments), Object.keys(target.arguments)).length) {
      throw Error('Function changes are not supported.');
    }

    forEach(source.node.arguments, function (valuesWithMeta, argument) {
      var values = target.arguments[argument];
      compareArgument(valuesWithMeta, values);
    });
  }

  function compareArgument(source, target) {
    if (source.length !== target.length) {
      throw Error('Arguments changes are not supported.');
    }

    zip(source, target).forEach(function (_ref3) {
      var _ref4 = _slicedToArray(_ref3, 2),
          valueWithMeta = _ref4[0],
          value = _ref4[1];

      return compareValue(valueWithMeta, value);
    });
  }

  function compareValue(source, target) {
    if (isAstWithMeta(source) && isAst(target)) {
      compareExpression(source, target);
      return;
    }

    if (source.node !== target) {
      changes.push({
        type: 'value',
        source: source,
        target: target
      });
    }
  }

  while (queue.length) {
    compareExpression.apply(void 0, _toConsumableArray(queue.shift()));
  }

  return changes;
}