/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
import { isAstWithMeta } from './ast';
import { compare, isValueChange } from './compare';
import { toExpression } from './to_expression';
export function patch(expression, ast) {
  var result = '';
  var position = 0;

  function apply(change) {
    if (isValueChange(change)) {
      return void patchValue(change);
    }

    throw new Error('Cannot apply patch for the change.');
  }

  function patchValue(change) {
    if (isAstWithMeta(change.source)) {
      throw new Error('Patching sub-expressions is not supported.');
    }

    result += "".concat(expression.substring(position, change.source.start)).concat(toExpression(change.target, 'argument'));
    position = change.source.end;
  }

  compare(expression, ast).sort(function (_ref, _ref2) {
    var source1 = _ref.source;
    var source2 = _ref2.source;
    return source1.start - source2.start;
  }).forEach(apply);
  result += expression.substring(position);
  return result;
}