"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.updateExceptionListItemSchema = void 0;

var t = _interopRequireWildcard(require("io-ts"));

var _default_update_comments_array = require("../../common/default_update_comments_array");

var _exception_list_item_type = require("../../common/exception_list_item_type");

var _non_empty_entries_array = require("../../common/non_empty_entries_array");

var _os_type = require("../../common/os_type");

var _tags = require("../../common/tags");

var _description = require("../../common/description");

var _name = require("../../common/name");

var _underscore_version = require("../../common/underscore_version");

var _id = require("../../common/id");

var _meta = require("../../common/meta");

var _namespace_type = require("../../common/namespace_type");

function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }

function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
const updateExceptionListItemSchema = t.intersection([t.exact(t.type({
  description: _description.description,
  entries: _non_empty_entries_array.nonEmptyEntriesArray,
  name: _name.name,
  type: _exception_list_item_type.exceptionListItemType
})), t.exact(t.partial({
  _version: _underscore_version._version,
  // defaults to undefined if not set during decode
  comments: _default_update_comments_array.DefaultUpdateCommentsArray,
  // defaults to empty array if not set during decode
  id: _id.id,
  // defaults to undefined if not set during decode
  item_id: t.union([t.string, t.undefined]),
  meta: _meta.meta,
  // defaults to undefined if not set during decode
  namespace_type: _namespace_type.namespace_type,
  // defaults to 'single' if not set during decode
  os_types: _os_type.osTypeArrayOrUndefined,
  // defaults to empty array if not set during decode
  tags: _tags.tags // defaults to empty array if not set during decode

}))]);
exports.updateExceptionListItemSchema = updateExceptionListItemSchema;