/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
import * as t from 'io-ts';
import { NonEmptyString } from '@kbn/securitysolution-io-ts-types';
import { nonEmptyEndpointNestedEntriesArray } from '../non_empty_nested_entries_array';
export var endpointEntryNested = t.exact(t.type({
  entries: nonEmptyEndpointNestedEntriesArray,
  field: NonEmptyString,
  type: t.keyof({
    nested: null
  })
}));