import _defineProperty from "@babel/runtime/helpers/defineProperty";
import _objectSpread from "@babel/runtime/helpers/objectSpread2";

/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
import { isPlainObject } from 'lodash';
import { ruleTypeMappings } from './rule_type_mappings';
export var isRuleType = function isRuleType(ruleType) {
  return Object.keys(ruleTypeMappings).includes(ruleType);
};
export var isRuleTypeId = function isRuleTypeId(ruleTypeId) {
  return Object.values(ruleTypeMappings).includes(ruleTypeId);
};
export var flattenWithPrefix = function flattenWithPrefix(prefix, maybeObj) {
  if (maybeObj != null && isPlainObject(maybeObj)) {
    return Object.keys(maybeObj).reduce(function (acc, key) {
      return _objectSpread(_objectSpread({}, acc), flattenWithPrefix("".concat(prefix, ".").concat(key), maybeObj[key]));
    }, {});
  } else {
    return _defineProperty({}, prefix, maybeObj);
  }
};