/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

/**
 * Returns true if any modifier key is active on the event, false otherwise.
 */
export var hasActiveModifierKey = function hasActiveModifierKey(event) {
  return event.metaKey || event.altKey || event.ctrlKey || event.shiftKey;
};
/**
 * Returns the closest anchor (`<a>`) element in the element parents (self included) up
 * to the given container (excluded), or undefined if none is found.
 */

export var getClosestLink = function getClosestLink(element, container) {
  var current = element;

  do {
    var _current, _current2;

    if (((_current = current) === null || _current === void 0 ? void 0 : _current.tagName.toLowerCase()) === 'a') {
      return current;
    }

    var _parent = (_current2 = current) === null || _current2 === void 0 ? void 0 : _current2.parentElement;

    if (!_parent || _parent === document.body || _parent === container) {
      break;
    }

    current = _parent;
  } while (parent || parent !== document.body || parent !== container);

  return undefined;
};