"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.mockOptionsListContext = void 0;

/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
const mockOptionsListComponentState = {
  field: undefined,
  totalCardinality: 0,
  availableOptions: ['woof', 'bark', 'meow', 'quack', 'moo'],
  invalidSelections: [],
  validSelections: [],
  searchString: ''
};
const mockOptionsListEmbeddableInput = {
  id: 'sample options list',
  fieldName: 'sample field',
  dataViewId: 'sample id',
  selectedOptions: [],
  runPastTimeout: false,
  singleSelect: false
};
const mockOptionsListOutput = {
  loading: false
};

const mockOptionsListContext = partialState => {
  const mockReduxState = {
    componentState: { ...mockOptionsListComponentState,
      ...(partialState === null || partialState === void 0 ? void 0 : partialState.componentState)
    },
    explicitInput: { ...mockOptionsListEmbeddableInput,
      ...(partialState === null || partialState === void 0 ? void 0 : partialState.explicitInput)
    },
    output: { ...mockOptionsListOutput,
      ...(partialState === null || partialState === void 0 ? void 0 : partialState.output)
    }
  };
  return {
    actions: {},
    useEmbeddableDispatch: () => {},
    useEmbeddableSelector: selector => selector(mockReduxState)
  };
};

exports.mockOptionsListContext = mockOptionsListContext;