"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.trackLegacyRBACExemption = trackLegacyRBACExemption;

/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function trackLegacyRBACExemption(source, usageCounter, increment) {
  if (usageCounter) {
    usageCounter.incrementCounter({
      counterName: `source_${source}`,
      counterType: 'legacyRBACExemption',
      incrementBy: increment ? increment : 1
    });
  }
}