"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getGlobalApmServerRouteRepository = void 0;

var _route = require("../agent_keys/route");

var _route2 = require("../alerts/route");

var _route3 = require("../dependencies/route");

var _route4 = require("../correlations/route");

var _route5 = require("../data_view/route");

var _route6 = require("../debug_telemetry/route");

var _route7 = require("../environments/route");

var _route8 = require("../errors/route");

var _route9 = require("../event_metadata/route");

var _route10 = require("../fallback_to_transactions/route");

var _route11 = require("../fleet/route");

var _route12 = require("../historical_data/route");

var _route13 = require("../infrastructure/route");

var _route14 = require("../latency_distribution/route");

var _route15 = require("../metrics/route");

var _route16 = require("../observability_overview/route");

var _route17 = require("../services/route");

var _route18 = require("../service_groups/route");

var _route19 = require("../service_map/route");

var _route20 = require("../service_nodes/route");

var _route21 = require("../settings/agent_configuration/route");

var _route22 = require("../settings/anomaly_detection/route");

var _route23 = require("../settings/apm_indices/route");

var _route24 = require("../settings/custom_link/route");

var _route25 = require("../source_maps/route");

var _route26 = require("../span_links/route");

var _route27 = require("../suggestions/route");

var _route28 = require("../time_range_metadata/route");

var _route29 = require("../traces/route");

var _route30 = require("../transactions/route");

var _route31 = require("../storage_explorer/route");

var _route32 = require("../settings/labs/route");

/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function getTypedGlobalApmServerRouteRepository() {
  const repository = { ..._route5.dataViewRouteRepository,
    ..._route7.environmentsRouteRepository,
    ..._route8.errorsRouteRepository,
    ..._route14.latencyDistributionRouteRepository,
    ..._route15.metricsRouteRepository,
    ..._route16.observabilityOverviewRouteRepository,
    ..._route19.serviceMapRouteRepository,
    ..._route20.serviceNodeRouteRepository,
    ..._route17.serviceRouteRepository,
    ..._route18.serviceGroupRouteRepository,
    ..._route27.suggestionsRouteRepository,
    ..._route29.traceRouteRepository,
    ..._route30.transactionRouteRepository,
    ..._route2.alertsChartPreviewRouteRepository,
    ..._route21.agentConfigurationRouteRepository,
    ..._route22.anomalyDetectionRouteRepository,
    ..._route23.apmIndicesRouteRepository,
    ..._route24.customLinkRouteRepository,
    ..._route25.sourceMapsRouteRepository,
    ..._route11.apmFleetRouteRepository,
    ..._route3.dependencisRouteRepository,
    ..._route4.correlationsRouteRepository,
    ..._route10.fallbackToTransactionsRouteRepository,
    ..._route12.historicalDataRouteRepository,
    ..._route9.eventMetadataRouteRepository,
    ..._route.agentKeysRouteRepository,
    ..._route31.storageExplorerRouteRepository,
    ..._route26.spanLinksRouteRepository,
    ..._route13.infrastructureRouteRepository,
    ..._route6.debugTelemetryRoute,
    ..._route28.timeRangeMetadataRoute,
    ..._route32.labsRouteRepository
  };
  return repository;
}

const getGlobalApmServerRouteRepository = () => {
  return getTypedGlobalApmServerRouteRepository();
};

exports.getGlobalApmServerRouteRepository = getGlobalApmServerRouteRepository;

function assertType() {} // if any endpoint has an array-like return type, the assertion below will fail


assertType();