"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getActiveInstances = getActiveInstances;

var _i18n = require("@kbn/i18n");

var _server = require("../../../../../../observability/server");

var _uiTheme = require("@kbn/ui-theme");

var _elasticsearch_fieldnames = require("../../../../../common/elasticsearch_fieldnames");

var _environment_query = require("../../../../../common/utils/environment_query");

var _metrics = require("../../../../lib/helpers/metrics");

var _transactions = require("../../../../lib/helpers/transactions");

/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
async function getActiveInstances({
  environment,
  kuery,
  setup,
  serviceName,
  start,
  end,
  searchAggregatedTransactions
}) {
  var _aggregations$activeI;

  const {
    apmEventClient,
    config
  } = setup;
  const aggs = {
    activeInstances: {
      cardinality: {
        field: _elasticsearch_fieldnames.SERVICE_NODE_NAME
      }
    }
  };
  const params = {
    apm: {
      events: [(0, _transactions.getProcessorEventForTransactions)(searchAggregatedTransactions)]
    },
    body: {
      track_total_hits: false,
      size: 0,
      query: {
        bool: {
          filter: [{
            term: {
              [_elasticsearch_fieldnames.SERVICE_NAME]: serviceName
            }
          }, ...(0, _server.rangeQuery)(start, end), ...(0, _environment_query.environmentQuery)(environment), ...(0, _server.kqlQuery)(kuery), ...(0, _transactions.getDocumentTypeFilterForTransactions)(searchAggregatedTransactions)]
        }
      },
      aggs: { ...aggs,
        timeseriesData: {
          date_histogram: (0, _metrics.getMetricsDateHistogramParams)({
            start,
            end,
            metricsInterval: config.metricsInterval
          }),
          aggs
        }
      }
    }
  };
  const {
    aggregations
  } = await apmEventClient.search('get_active_instances', params);
  return {
    title: _i18n.i18n.translate('xpack.apm.agentMetrics.serverless.activeInstances', {
      defaultMessage: 'Active instances'
    }),
    key: 'active_instances',
    yUnit: 'integer',
    description: _i18n.i18n.translate('xpack.apm.agentMetrics.serverless.activeInstances.description', {
      defaultMessage: 'This chart shows the number of active instances of your serverless function over time. Multiple active instances may be a result of provisioned concurrency for your function or an increase in concurrent load that scales your function on-demand. An increase in active instance can be an indicator for an increase in concurrent invocations.'
    }),
    series: [{
      title: _i18n.i18n.translate('xpack.apm.agentMetrics.serverless.series.activeInstances', {
        defaultMessage: 'Active instances'
      }),
      key: 'active_instances',
      type: 'bar',
      color: _uiTheme.euiLightVars.euiColorVis1,
      overallValue: (_aggregations$activeI = aggregations === null || aggregations === void 0 ? void 0 : aggregations.activeInstances.value) !== null && _aggregations$activeI !== void 0 ? _aggregations$activeI : 0,
      data: (aggregations === null || aggregations === void 0 ? void 0 : aggregations.timeseriesData.buckets.map(timeseriesBucket => ({
        x: timeseriesBucket.key,
        y: timeseriesBucket.activeInstances.value
      }))) || []
    }]
  };
}