"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getServerlessAgentMetricCharts = getServerlessAgentMetricCharts;

var _with_apm_span = require("../../../../utils/with_apm_span");

var _serverless_function_latency = require("./serverless_function_latency");

var _cold_start_duration = require("./cold_start_duration");

var _memory = require("../shared/memory");

var _compute_usage = require("./compute_usage");

var _active_instances = require("./active_instances");

var _cold_start_count = require("./cold_start_count");

var _transactions = require("../../../../lib/helpers/transactions");

/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function getServerlessAgentMetricCharts({
  environment,
  kuery,
  setup,
  serviceName,
  start,
  end
}) {
  return (0, _with_apm_span.withApmSpan)('get_serverless_agent_metric_charts', async () => {
    const searchAggregatedTransactions = await (0, _transactions.getSearchAggregatedTransactions)({ ...setup,
      kuery,
      start,
      end
    });
    const options = {
      environment,
      kuery,
      setup,
      serviceName,
      start,
      end
    };
    return await Promise.all([(0, _serverless_function_latency.getServerlessFunctionLatency)({ ...options,
      searchAggregatedTransactions
    }), (0, _memory.getMemoryChartData)(options), (0, _cold_start_duration.getColdStartDuration)(options), (0, _cold_start_count.getColdStartCount)(options), (0, _compute_usage.getComputeUsage)(options), (0, _active_instances.getActiveInstances)({ ...options,
      searchAggregatedTransactions
    })]);
  });
}