"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getMetricsChartDataByAgent = getMetricsChartDataByAgent;

var _java = require("./by_agent/java");

var _default = require("./by_agent/default");

var _agent_name = require("../../../common/agent_name");

var _serverless = require("./by_agent/serverless");

/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
async function getMetricsChartDataByAgent({
  environment,
  kuery,
  setup,
  serviceName,
  serviceNodeName,
  agentName,
  start,
  end,
  serviceRuntimeName
}) {
  const options = {
    environment,
    kuery,
    setup,
    serviceName,
    start,
    end
  };
  const serverlessAgent = (0, _agent_name.isServerlessAgent)(serviceRuntimeName);

  if ((0, _agent_name.isJavaAgentName)(agentName) && !serverlessAgent) {
    return (0, _java.getJavaMetricsCharts)({ ...options,
      serviceNodeName
    });
  }

  if (serverlessAgent) {
    return (0, _serverless.getServerlessAgentMetricCharts)(options);
  }

  return (0, _default.getDefaultMetricsCharts)(options);
}