"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getEstimatedSizeForDocumentsInIndex = getEstimatedSizeForDocumentsInIndex;
exports.getTotalIndicesStats = getTotalIndicesStats;

var _lodash = require("lodash");

/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
async function getTotalIndicesStats({
  context,
  setup
}) {
  const {
    indices: {
      transaction,
      span,
      metric,
      error
    }
  } = setup;
  const index = (0, _lodash.uniq)([transaction, span, metric, error]).join();
  const esClient = (await context.core).elasticsearch.client;
  const totalStats = await esClient.asCurrentUser.indices.stats({
    index
  });
  return totalStats;
}

function getEstimatedSizeForDocumentsInIndex({
  allIndicesStats,
  indexName,
  numberOfDocs
}) {
  var _indexStats$total$sto, _indexStats$total, _indexStats$total$sto2, _indexStats$total2, _indexStats$total2$do;

  const indexStats = allIndicesStats[indexName];
  const indexTotalSize = (_indexStats$total$sto = indexStats === null || indexStats === void 0 ? void 0 : (_indexStats$total = indexStats.total) === null || _indexStats$total === void 0 ? void 0 : (_indexStats$total$sto2 = _indexStats$total.store) === null || _indexStats$total$sto2 === void 0 ? void 0 : _indexStats$total$sto2.size_in_bytes) !== null && _indexStats$total$sto !== void 0 ? _indexStats$total$sto : 0;
  const indexTotalDocCount = indexStats === null || indexStats === void 0 ? void 0 : (_indexStats$total2 = indexStats.total) === null || _indexStats$total2 === void 0 ? void 0 : (_indexStats$total2$do = _indexStats$total2.docs) === null || _indexStats$total2$do === void 0 ? void 0 : _indexStats$total2$do.count;
  const estimatedSize = indexTotalDocCount ? numberOfDocs / indexTotalDocCount * indexTotalSize : 0;
  return estimatedSize;
}