"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CloudExperimentsPlugin = void 0;

var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));

var _lodash = require("lodash");

var _launchdarklyNodeServerSdk = _interopRequireDefault(require("launchdarkly-node-server-sdk"));

var _usage = require("./usage");

var _constants = require("../common/constants");

/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
class CloudExperimentsPlugin {
  constructor(initializerContext) {
    (0, _defineProperty2.default)(this, "logger", void 0);
    (0, _defineProperty2.default)(this, "launchDarklyClient", void 0);
    (0, _defineProperty2.default)(this, "flagOverrides", void 0);
    (0, _defineProperty2.default)(this, "launchDarklyUser", void 0);
    (0, _defineProperty2.default)(this, "getVariation", async (featureFlagName, defaultValue) => {
      var _this$launchDarklyCli, _this$launchDarklyCli2;

      const configKey = _constants.FEATURE_FLAG_NAMES[featureFlagName]; // Apply overrides if they exist without asking LaunchDarkly.

      if (this.flagOverrides && (0, _lodash.has)(this.flagOverrides, configKey)) {
        return (0, _lodash.get)(this.flagOverrides, configKey, defaultValue);
      }

      if (!this.launchDarklyUser) return defaultValue; // Skip any action if no LD User is defined

      await ((_this$launchDarklyCli = this.launchDarklyClient) === null || _this$launchDarklyCli === void 0 ? void 0 : _this$launchDarklyCli.waitForInitialization());
      return await ((_this$launchDarklyCli2 = this.launchDarklyClient) === null || _this$launchDarklyCli2 === void 0 ? void 0 : _this$launchDarklyCli2.variation(configKey, this.launchDarklyUser, defaultValue));
    });
    (0, _defineProperty2.default)(this, "reportMetric", ({
      name,
      meta,
      value
    }) => {
      var _this$launchDarklyCli3;

      const metricName = _constants.METRIC_NAMES[name];
      if (!this.launchDarklyUser) return; // Skip any action if no LD User is defined

      (_this$launchDarklyCli3 = this.launchDarklyClient) === null || _this$launchDarklyCli3 === void 0 ? void 0 : _this$launchDarklyCli3.track(metricName, this.launchDarklyUser, meta, value);
      this.logger.debug(`Reported experimentation metric ${metricName}`, {
        experimentationMetric: {
          name,
          meta,
          value
        }
      });
    });
    this.logger = initializerContext.logger.get();
    const config = initializerContext.config.get();

    if (config.flag_overrides) {
      this.flagOverrides = config.flag_overrides;
    }

    const ldConfig = config.launch_darkly; // If the plugin is enabled and no flag_overrides are provided (dev mode only), launch_darkly must exist

    if (!ldConfig && !initializerContext.env.mode.dev) {
      // If the plugin is enabled, and it's in prod mode, launch_darkly must exist
      // (config-schema should enforce it, but just in case).
      throw new Error('xpack.cloud_integrations.experiments.launch_darkly configuration should exist');
    }

    if (ldConfig) {
      this.launchDarklyClient = _launchdarklyNodeServerSdk.default.init(ldConfig.sdk_key, {
        application: {
          id: `kibana-server`,
          version: initializerContext.env.packageInfo.version
        },
        logger: _launchdarklyNodeServerSdk.default.basicLogger({
          level: ldConfig.client_log_level
        }),
        // For some reason, the stream API does not work in Kibana. `.waitForInitialization()` hangs forever (doesn't throw, neither logs any errors).
        // Using polling for now until we resolve that issue.
        // Relevant issue: https://github.com/launchdarkly/node-server-sdk/issues/132
        stream: false
      });
      this.launchDarklyClient.waitForInitialization().then(() => this.logger.debug('LaunchDarkly is initialized!'), err => this.logger.warn(`Error initializing LaunchDarkly: ${err}`));
    }
  }

  setup(core, deps) {
    if (deps.usageCollection) {
      (0, _usage.registerUsageCollector)(deps.usageCollection, () => ({
        launchDarklyClient: this.launchDarklyClient,
        launchDarklyUser: this.launchDarklyUser
      }));
    }

    return {
      identifyUser: (userId, userMetadata) => {
        var _this$launchDarklyCli4;

        this.launchDarklyUser = {
          key: userId,
          custom: userMetadata
        };
        (_this$launchDarklyCli4 = this.launchDarklyClient) === null || _this$launchDarklyCli4 === void 0 ? void 0 : _this$launchDarklyCli4.identify(this.launchDarklyUser);
      }
    };
  }

  start(core) {
    return {
      getVariation: this.getVariation,
      reportMetric: this.reportMetric
    };
  }

  stop() {
    var _this$launchDarklyCli5;

    (_this$launchDarklyCli5 = this.launchDarklyClient) === null || _this$launchDarklyCli5 === void 0 ? void 0 : _this$launchDarklyCli5.flush().catch(err => this.logger.error(err));
  }

}

exports.CloudExperimentsPlugin = CloudExperimentsPlugin;