"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createFileServiceMock = exports.createFileServiceFactoryMock = void 0;

/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const createFileServiceMock = () => ({
  create: jest.fn(),
  delete: jest.fn(),
  deleteShareObject: jest.fn(),
  find: jest.fn(),
  getById: jest.fn(),
  getByToken: jest.fn(),
  getShareObject: jest.fn(),
  getUsageMetrics: jest.fn(),
  listShareObjects: jest.fn(),
  update: jest.fn(),
  updateShareObject: jest.fn()
});

exports.createFileServiceMock = createFileServiceMock;

const createFileServiceFactoryMock = () => ({
  asInternal: jest.fn(createFileServiceMock),
  asScoped: jest.fn(_ => createFileServiceMock())
});

exports.createFileServiceFactoryMock = createFileServiceFactoryMock;