"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.method = exports.handler = void 0;
exports.register = register;

var _configSchema = require("@kbn/config-schema");

var _api_routes = require("../api_routes");

var _find = require("../find");

/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const method = 'post';
exports.method = method;
const rt = {
  body: _configSchema.schema.object({
    status: _configSchema.schema.maybe(_find.stringOrArrayOfStrings),
    extension: _configSchema.schema.maybe(_find.stringOrArrayOfStrings),
    name: _configSchema.schema.maybe(_find.nameStringOrArrayOfNameStrings),
    meta: _configSchema.schema.maybe(_configSchema.schema.object({}, {
      unknowns: 'allow'
    }))
  }),
  query: _configSchema.schema.object({
    page: _configSchema.schema.maybe(_configSchema.schema.number()),
    perPage: _configSchema.schema.maybe(_configSchema.schema.number({
      defaultValue: 100
    }))
  })
};

const handler = async ({
  files,
  fileKind
}, req, res) => {
  const {
    body: {
      name,
      status,
      extension,
      meta
    },
    query: {
      page,
      perPage
    }
  } = req;
  const {
    fileService
  } = await files;
  const body = await fileService.asCurrentUser().find({
    kind: [fileKind],
    name: (0, _find.toArrayOrUndefined)(name),
    status: (0, _find.toArrayOrUndefined)(status),
    extension: (0, _find.toArrayOrUndefined)(extension),
    page,
    perPage,
    meta
  });
  return res.ok({
    body
  });
};

exports.handler = handler;

function register(fileKindRouter, fileKind) {
  if (fileKind.http.list) {
    fileKindRouter[method]({
      path: _api_routes.FILES_API_ROUTES.fileKind.getListRoute(fileKind.id),
      validate: { ...rt
      },
      options: {
        tags: fileKind.http.list.tags
      }
    }, handler);
  }
}