"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.method = exports.handler = void 0;
exports.register = register;

var _configSchema = require("@kbn/config-schema");

var _api_routes = require("../../api_routes");

/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const method = 'get';
exports.method = method;
const rt = {
  query: _configSchema.schema.object({
    page: _configSchema.schema.maybe(_configSchema.schema.number()),
    perPage: _configSchema.schema.maybe(_configSchema.schema.number()),
    forFileId: _configSchema.schema.maybe(_configSchema.schema.string())
  })
};

const handler = async ({
  files
}, req, res) => {
  const {
    fileService
  } = await files;
  const {
    query: {
      forFileId,
      page,
      perPage
    }
  } = req;
  const result = await fileService.asCurrentUser().listShareObjects({
    fileId: forFileId,
    page,
    perPage
  });
  const body = result;
  return res.ok({
    body
  });
};

exports.handler = handler;

function register(fileKindRouter, fileKind) {
  if (fileKind.http.share) {
    fileKindRouter[method]({
      path: _api_routes.FILES_API_ROUTES.fileKind.getListShareRoute(fileKind.id),
      validate: { ...rt
      },
      options: {
        tags: fileKind.http.share.tags
      }
    }, handler);
  }
}