"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.register = register;

var _constants = require("../../common/constants");

var _api_routes = require("./api_routes");

/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const method = 'get';

const handler = async ({
  files
}, req, res) => {
  const {
    fileService
  } = await files;
  const body = await fileService.asCurrentUser().getUsageMetrics();
  return res.ok({
    body
  });
};

function register(router) {
  router[method]({
    path: _api_routes.FILES_API_ROUTES.metrics,
    validate: {},
    options: {
      tags: [`access:${_constants.FILES_MANAGE_PRIVILEGE}`]
    }
  }, handler);
}