"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UpdateAgentTagsActionRunner = void 0;
exports.updateTagsBatch = updateTagsBatch;

var _uuid = _interopRequireDefault(require("uuid"));

var _lodash = require("lodash");

var _action_runner = require("./action_runner");

var _crud = require("./crud");

var _bulk_actions_resolver = require("./bulk_actions_resolver");

var _filter_hosted_agents = require("./filter_hosted_agents");

var _actions = require("./actions");

/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
class UpdateAgentTagsActionRunner extends _action_runner.ActionRunner {
  async processAgents(agents) {
    var _this$actionParams, _this$actionParams2;

    return await updateTagsBatch(this.soClient, this.esClient, agents, {}, {
      tagsToAdd: (_this$actionParams = this.actionParams) === null || _this$actionParams === void 0 ? void 0 : _this$actionParams.tagsToAdd,
      tagsToRemove: (_this$actionParams2 = this.actionParams) === null || _this$actionParams2 === void 0 ? void 0 : _this$actionParams2.tagsToRemove,
      actionId: this.actionParams.actionId,
      total: this.actionParams.total
    });
  }

  getTaskType() {
    return _bulk_actions_resolver.BulkActionTaskType.UPDATE_AGENT_TAGS_RETRY;
  }

  getActionType() {
    return 'UPDATE_TAGS';
  }

}

exports.UpdateAgentTagsActionRunner = UpdateAgentTagsActionRunner;

async function updateTagsBatch(soClient, esClient, givenAgents, outgoingErrors, options) {
  var _options$actionId, _options$total;

  const errors = { ...outgoingErrors
  };
  const filteredAgents = await (0, _filter_hosted_agents.filterHostedPolicies)(soClient, givenAgents, errors, `Cannot modify tags on a hosted agent`);

  const getNewTags = agent => {
    var _agent$tags;

    const existingTags = (_agent$tags = agent.tags) !== null && _agent$tags !== void 0 ? _agent$tags : [];

    if (options.tagsToAdd.length === 1 && options.tagsToRemove.length === 1) {
      const removableTagIndex = existingTags.indexOf(options.tagsToRemove[0]);

      if (removableTagIndex > -1) {
        const newTags = (0, _lodash.uniq)([...existingTags.slice(0, removableTagIndex), options.tagsToAdd[0], ...existingTags.slice(removableTagIndex + 1)]);
        return newTags;
      }
    }

    return (0, _lodash.uniq)((0, _lodash.difference)(existingTags, options.tagsToRemove).concat(options.tagsToAdd));
  };

  await (0, _crud.bulkUpdateAgents)(esClient, filteredAgents.map(agent => ({
    agentId: agent.id,
    data: {
      tags: getNewTags(agent)
    }
  })), errors);
  const actionId = (_options$actionId = options.actionId) !== null && _options$actionId !== void 0 ? _options$actionId : (0, _uuid.default)();
  const total = (_options$total = options.total) !== null && _options$total !== void 0 ? _options$total : givenAgents.length; // creating an action doc so that update tags  shows up in activity

  await (0, _actions.createAgentAction)(esClient, {
    id: actionId,
    agents: [],
    created_at: new Date().toISOString(),
    type: 'UPDATE_TAGS',
    total
  });
  await (0, _actions.bulkCreateAgentActionResults)(esClient, filteredAgents.map(agent => ({
    agentId: agent.id,
    actionId
  })));
  await (0, _actions.createErrorActionResults)(esClient, actionId, errors, 'cannot modified tags on hosted agents');
  return {
    actionId
  };
}