"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.slosRouteRepository = void 0;

var _slo = require("../../services/slo");

var _transform_generators = require("../../services/slo/transform_generators");

var _schema = require("../../types/schema");

var _create_observability_server_route = require("../create_observability_server_route");

/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const transformGenerators = {
  'slo.apm.transaction_duration': new _transform_generators.ApmTransactionDurationTransformGenerator(),
  'slo.apm.transaction_error_rate': new _transform_generators.ApmTransactionErrorRateTransformGenerator()
};
const createSLORoute = (0, _create_observability_server_route.createObservabilityServerRoute)({
  endpoint: 'POST /api/observability/slos',
  options: {
    tags: []
  },
  params: _schema.createSLOParamsSchema,
  handler: async ({
    context,
    request,
    params,
    logger,
    spacesService
  }) => {
    const esClient = (await context.core).elasticsearch.client.asCurrentUser;
    const soClient = (await context.core).savedObjects.client;
    const spaceId = spacesService.getSpaceId(request);
    const resourceInstaller = new _slo.DefaultResourceInstaller(esClient, logger, spaceId);
    const repository = new _slo.KibanaSavedObjectsSLORepository(soClient);
    const transformManager = new _slo.DefaultTransformManager(transformGenerators, esClient, logger, spaceId);
    const createSLO = new _slo.CreateSLO(resourceInstaller, repository, transformManager);
    const response = await createSLO.execute(params.body);
    return response;
  }
});
const deleteSLORoute = (0, _create_observability_server_route.createObservabilityServerRoute)({
  endpoint: 'DELETE /api/observability/slos/{id}',
  options: {
    tags: []
  },
  params: _schema.deleteSLOParamsSchema,
  handler: async ({
    context,
    request,
    params,
    logger,
    spacesService
  }) => {
    const esClient = (await context.core).elasticsearch.client.asCurrentUser;
    const soClient = (await context.core).savedObjects.client;
    const spaceId = spacesService.getSpaceId(request);
    const repository = new _slo.KibanaSavedObjectsSLORepository(soClient);
    const transformManager = new _slo.DefaultTransformManager(transformGenerators, esClient, logger, spaceId);
    const deleteSLO = new _slo.DeleteSLO(repository, transformManager, esClient);
    await deleteSLO.execute(params.path.id);
  }
});
const slosRouteRepository = { ...createSLORoute,
  ...deleteSLORoute
};
exports.slosRouteRepository = slosRouteRepository;