"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.rollingTimeWindowSchema = exports.indicatorTypesSchema = exports.indicatorSchema = exports.deleteSLOParamsSchema = exports.createSLOParamsSchema = exports.apmTransactionErrorRateIndicatorSchema = exports.apmTransactionDurationIndicatorSchema = exports.ALL_VALUE = void 0;

var t = _interopRequireWildcard(require("io-ts"));

function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }

function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const ALL_VALUE = 'ALL';
exports.ALL_VALUE = ALL_VALUE;
const allOrAnyString = t.union([t.literal(ALL_VALUE), t.string]);
const apmTransactionDurationIndicatorTypeSchema = t.literal('slo.apm.transaction_duration');
const apmTransactionDurationIndicatorSchema = t.type({
  type: apmTransactionDurationIndicatorTypeSchema,
  params: t.type({
    environment: allOrAnyString,
    service: allOrAnyString,
    transaction_type: allOrAnyString,
    transaction_name: allOrAnyString,
    'threshold.us': t.number
  })
});
exports.apmTransactionDurationIndicatorSchema = apmTransactionDurationIndicatorSchema;
const apmTransactionErrorRateIndicatorTypeSchema = t.literal('slo.apm.transaction_error_rate');
const apmTransactionErrorRateIndicatorSchema = t.type({
  type: apmTransactionErrorRateIndicatorTypeSchema,
  params: t.intersection([t.type({
    environment: allOrAnyString,
    service: allOrAnyString,
    transaction_type: allOrAnyString,
    transaction_name: allOrAnyString
  }), t.partial({
    good_status_codes: t.array(t.union([t.literal('2xx'), t.literal('3xx'), t.literal('4xx'), t.literal('5xx')]))
  })])
});
exports.apmTransactionErrorRateIndicatorSchema = apmTransactionErrorRateIndicatorSchema;
const rollingTimeWindowSchema = t.type({
  duration: t.string,
  is_rolling: t.literal(true)
});
exports.rollingTimeWindowSchema = rollingTimeWindowSchema;
const indicatorTypesSchema = t.union([apmTransactionDurationIndicatorTypeSchema, apmTransactionErrorRateIndicatorTypeSchema]);
exports.indicatorTypesSchema = indicatorTypesSchema;
const indicatorSchema = t.union([apmTransactionDurationIndicatorSchema, apmTransactionErrorRateIndicatorSchema]);
exports.indicatorSchema = indicatorSchema;
const createSLOBodySchema = t.type({
  name: t.string,
  description: t.string,
  indicator: indicatorSchema,
  time_window: rollingTimeWindowSchema,
  budgeting_method: t.literal('occurrences'),
  objective: t.type({
    target: t.number
  })
});
const createSLOResponseSchema = t.type({
  id: t.string
});
const createSLOParamsSchema = t.type({
  body: createSLOBodySchema
});
exports.createSLOParamsSchema = createSLOParamsSchema;
const deleteSLOParamsSchema = t.type({
  path: t.type({
    id: t.string
  })
});
exports.deleteSLOParamsSchema = deleteSLOParamsSchema;