"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ecsFieldMap = void 0;

/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/* This file is generated by x-pack/plugins/rule_registry/scripts/generate_ecs_fieldmap/index.js,
do not manually edit
*/
const ecsFieldMap = {
  '@timestamp': {
    type: 'date',
    array: false,
    required: true
  },
  'agent.build.original': {
    type: 'keyword',
    array: false,
    required: false
  },
  'agent.ephemeral_id': {
    type: 'keyword',
    array: false,
    required: false
  },
  'agent.id': {
    type: 'keyword',
    array: false,
    required: false
  },
  'agent.name': {
    type: 'keyword',
    array: false,
    required: false
  },
  'agent.type': {
    type: 'keyword',
    array: false,
    required: false
  },
  'agent.version': {
    type: 'keyword',
    array: false,
    required: false
  },
  'client.address': {
    type: 'keyword',
    array: false,
    required: false
  },
  'client.as.number': {
    type: 'long',
    array: false,
    required: false
  },
  'client.as.organization.name': {
    type: 'keyword',
    array: false,
    required: false
  },
  'client.bytes': {
    type: 'long',
    array: false,
    required: false
  },
  'client.domain': {
    type: 'keyword',
    array: false,
    required: false
  },
  'client.geo.city_name': {
    type: 'keyword',
    array: false,
    required: false
  },
  'client.geo.continent_code': {
    type: 'keyword',
    array: false,
    required: false
  },
  'client.geo.continent_name': {
    type: 'keyword',
    array: false,
    required: false
  },
  'client.geo.country_iso_code': {
    type: 'keyword',
    array: false,
    required: false
  },
  'client.geo.country_name': {
    type: 'keyword',
    array: false,
    required: false
  },
  'client.geo.location': {
    type: 'geo_point',
    array: false,
    required: false
  },
  'client.geo.name': {
    type: 'keyword',
    array: false,
    required: false
  },
  'client.geo.postal_code': {
    type: 'keyword',
    array: false,
    required: false
  },
  'client.geo.region_iso_code': {
    type: 'keyword',
    array: false,
    required: false
  },
  'client.geo.region_name': {
    type: 'keyword',
    array: false,
    required: false
  },
  'client.geo.timezone': {
    type: 'keyword',
    array: false,
    required: false
  },
  'client.ip': {
    type: 'ip',
    array: false,
    required: false
  },
  'client.mac': {
    type: 'keyword',
    array: false,
    required: false
  },
  'client.nat.ip': {
    type: 'ip',
    array: false,
    required: false
  },
  'client.nat.port': {
    type: 'long',
    array: false,
    required: false
  },
  'client.packets': {
    type: 'long',
    array: false,
    required: false
  },
  'client.port': {
    type: 'long',
    array: false,
    required: false
  },
  'client.registered_domain': {
    type: 'keyword',
    array: false,
    required: false
  },
  'client.subdomain': {
    type: 'keyword',
    array: false,
    required: false
  },
  'client.top_level_domain': {
    type: 'keyword',
    array: false,
    required: false
  },
  'client.user.domain': {
    type: 'keyword',
    array: false,
    required: false
  },
  'client.user.email': {
    type: 'keyword',
    array: false,
    required: false
  },
  'client.user.full_name': {
    type: 'keyword',
    array: false,
    required: false
  },
  'client.user.group.domain': {
    type: 'keyword',
    array: false,
    required: false
  },
  'client.user.group.id': {
    type: 'keyword',
    array: false,
    required: false
  },
  'client.user.group.name': {
    type: 'keyword',
    array: false,
    required: false
  },
  'client.user.hash': {
    type: 'keyword',
    array: false,
    required: false
  },
  'client.user.id': {
    type: 'keyword',
    array: false,
    required: false
  },
  'client.user.name': {
    type: 'keyword',
    array: false,
    required: false
  },
  'client.user.roles': {
    type: 'keyword',
    array: true,
    required: false
  },
  'cloud.account.id': {
    type: 'keyword',
    array: false,
    required: false
  },
  'cloud.account.name': {
    type: 'keyword',
    array: false,
    required: false
  },
  'cloud.availability_zone': {
    type: 'keyword',
    array: false,
    required: false
  },
  'cloud.instance.id': {
    type: 'keyword',
    array: false,
    required: false
  },
  'cloud.instance.name': {
    type: 'keyword',
    array: false,
    required: false
  },
  'cloud.machine.type': {
    type: 'keyword',
    array: false,
    required: false
  },
  'cloud.origin.account.id': {
    type: 'keyword',
    array: false,
    required: false
  },
  'cloud.origin.account.name': {
    type: 'keyword',
    array: false,
    required: false
  },
  'cloud.origin.availability_zone': {
    type: 'keyword',
    array: false,
    required: false
  },
  'cloud.origin.instance.id': {
    type: 'keyword',
    array: false,
    required: false
  },
  'cloud.origin.instance.name': {
    type: 'keyword',
    array: false,
    required: false
  },
  'cloud.origin.machine.type': {
    type: 'keyword',
    array: false,
    required: false
  },
  'cloud.origin.project.id': {
    type: 'keyword',
    array: false,
    required: false
  },
  'cloud.origin.project.name': {
    type: 'keyword',
    array: false,
    required: false
  },
  'cloud.origin.provider': {
    type: 'keyword',
    array: false,
    required: false
  },
  'cloud.origin.region': {
    type: 'keyword',
    array: false,
    required: false
  },
  'cloud.origin.service.name': {
    type: 'keyword',
    array: false,
    required: false
  },
  'cloud.project.id': {
    type: 'keyword',
    array: false,
    required: false
  },
  'cloud.project.name': {
    type: 'keyword',
    array: false,
    required: false
  },
  'cloud.provider': {
    type: 'keyword',
    array: false,
    required: false
  },
  'cloud.region': {
    type: 'keyword',
    array: false,
    required: false
  },
  'cloud.service.name': {
    type: 'keyword',
    array: false,
    required: false
  },
  'cloud.target.account.id': {
    type: 'keyword',
    array: false,
    required: false
  },
  'cloud.target.account.name': {
    type: 'keyword',
    array: false,
    required: false
  },
  'cloud.target.availability_zone': {
    type: 'keyword',
    array: false,
    required: false
  },
  'cloud.target.instance.id': {
    type: 'keyword',
    array: false,
    required: false
  },
  'cloud.target.instance.name': {
    type: 'keyword',
    array: false,
    required: false
  },
  'cloud.target.machine.type': {
    type: 'keyword',
    array: false,
    required: false
  },
  'cloud.target.project.id': {
    type: 'keyword',
    array: false,
    required: false
  },
  'cloud.target.project.name': {
    type: 'keyword',
    array: false,
    required: false
  },
  'cloud.target.provider': {
    type: 'keyword',
    array: false,
    required: false
  },
  'cloud.target.region': {
    type: 'keyword',
    array: false,
    required: false
  },
  'cloud.target.service.name': {
    type: 'keyword',
    array: false,
    required: false
  },
  'container.id': {
    type: 'keyword',
    array: false,
    required: false
  },
  'container.image.name': {
    type: 'keyword',
    array: false,
    required: false
  },
  'container.image.tag': {
    type: 'keyword',
    array: true,
    required: false
  },
  'container.labels': {
    type: 'object',
    array: false,
    required: false
  },
  'container.name': {
    type: 'keyword',
    array: false,
    required: false
  },
  'container.runtime': {
    type: 'keyword',
    array: false,
    required: false
  },
  'destination.address': {
    type: 'keyword',
    array: false,
    required: false
  },
  'destination.as.number': {
    type: 'long',
    array: false,
    required: false
  },
  'destination.as.organization.name': {
    type: 'keyword',
    array: false,
    required: false
  },
  'destination.bytes': {
    type: 'long',
    array: false,
    required: false
  },
  'destination.domain': {
    type: 'keyword',
    array: false,
    required: false
  },
  'destination.geo.city_name': {
    type: 'keyword',
    array: false,
    required: false
  },
  'destination.geo.continent_code': {
    type: 'keyword',
    array: false,
    required: false
  },
  'destination.geo.continent_name': {
    type: 'keyword',
    array: false,
    required: false
  },
  'destination.geo.country_iso_code': {
    type: 'keyword',
    array: false,
    required: false
  },
  'destination.geo.country_name': {
    type: 'keyword',
    array: false,
    required: false
  },
  'destination.geo.location': {
    type: 'geo_point',
    array: false,
    required: false
  },
  'destination.geo.name': {
    type: 'keyword',
    array: false,
    required: false
  },
  'destination.geo.postal_code': {
    type: 'keyword',
    array: false,
    required: false
  },
  'destination.geo.region_iso_code': {
    type: 'keyword',
    array: false,
    required: false
  },
  'destination.geo.region_name': {
    type: 'keyword',
    array: false,
    required: false
  },
  'destination.geo.timezone': {
    type: 'keyword',
    array: false,
    required: false
  },
  'destination.ip': {
    type: 'ip',
    array: false,
    required: false
  },
  'destination.mac': {
    type: 'keyword',
    array: false,
    required: false
  },
  'destination.nat.ip': {
    type: 'ip',
    array: false,
    required: false
  },
  'destination.nat.port': {
    type: 'long',
    array: false,
    required: false
  },
  'destination.packets': {
    type: 'long',
    array: false,
    required: false
  },
  'destination.port': {
    type: 'long',
    array: false,
    required: false
  },
  'destination.registered_domain': {
    type: 'keyword',
    array: false,
    required: false
  },
  'destination.subdomain': {
    type: 'keyword',
    array: false,
    required: false
  },
  'destination.top_level_domain': {
    type: 'keyword',
    array: false,
    required: false
  },
  'destination.user.domain': {
    type: 'keyword',
    array: false,
    required: false
  },
  'destination.user.email': {
    type: 'keyword',
    array: false,
    required: false
  },
  'destination.user.full_name': {
    type: 'keyword',
    array: false,
    required: false
  },
  'destination.user.group.domain': {
    type: 'keyword',
    array: false,
    required: false
  },
  'destination.user.group.id': {
    type: 'keyword',
    array: false,
    required: false
  },
  'destination.user.group.name': {
    type: 'keyword',
    array: false,
    required: false
  },
  'destination.user.hash': {
    type: 'keyword',
    array: false,
    required: false
  },
  'destination.user.id': {
    type: 'keyword',
    array: false,
    required: false
  },
  'destination.user.name': {
    type: 'keyword',
    array: false,
    required: false
  },
  'destination.user.roles': {
    type: 'keyword',
    array: true,
    required: false
  },
  'dll.code_signature.digest_algorithm': {
    type: 'keyword',
    array: false,
    required: false
  },
  'dll.code_signature.exists': {
    type: 'boolean',
    array: false,
    required: false
  },
  'dll.code_signature.signing_id': {
    type: 'keyword',
    array: false,
    required: false
  },
  'dll.code_signature.status': {
    type: 'keyword',
    array: false,
    required: false
  },
  'dll.code_signature.subject_name': {
    type: 'keyword',
    array: false,
    required: false
  },
  'dll.code_signature.team_id': {
    type: 'keyword',
    array: false,
    required: false
  },
  'dll.code_signature.timestamp': {
    type: 'date',
    array: false,
    required: false
  },
  'dll.code_signature.trusted': {
    type: 'boolean',
    array: false,
    required: false
  },
  'dll.code_signature.valid': {
    type: 'boolean',
    array: false,
    required: false
  },
  'dll.hash.md5': {
    type: 'keyword',
    array: false,
    required: false
  },
  'dll.hash.sha1': {
    type: 'keyword',
    array: false,
    required: false
  },
  'dll.hash.sha256': {
    type: 'keyword',
    array: false,
    required: false
  },
  'dll.hash.sha512': {
    type: 'keyword',
    array: false,
    required: false
  },
  'dll.hash.ssdeep': {
    type: 'keyword',
    array: false,
    required: false
  },
  'dll.name': {
    type: 'keyword',
    array: false,
    required: false
  },
  'dll.path': {
    type: 'keyword',
    array: false,
    required: false
  },
  'dll.pe.architecture': {
    type: 'keyword',
    array: false,
    required: false
  },
  'dll.pe.company': {
    type: 'keyword',
    array: false,
    required: false
  },
  'dll.pe.description': {
    type: 'keyword',
    array: false,
    required: false
  },
  'dll.pe.file_version': {
    type: 'keyword',
    array: false,
    required: false
  },
  'dll.pe.imphash': {
    type: 'keyword',
    array: false,
    required: false
  },
  'dll.pe.original_file_name': {
    type: 'keyword',
    array: false,
    required: false
  },
  'dll.pe.product': {
    type: 'keyword',
    array: false,
    required: false
  },
  'dns.answers': {
    type: 'object',
    array: true,
    required: false
  },
  'dns.answers.class': {
    type: 'keyword',
    array: false,
    required: false
  },
  'dns.answers.data': {
    type: 'keyword',
    array: false,
    required: false
  },
  'dns.answers.name': {
    type: 'keyword',
    array: false,
    required: false
  },
  'dns.answers.ttl': {
    type: 'long',
    array: false,
    required: false
  },
  'dns.answers.type': {
    type: 'keyword',
    array: false,
    required: false
  },
  'dns.header_flags': {
    type: 'keyword',
    array: true,
    required: false
  },
  'dns.id': {
    type: 'keyword',
    array: false,
    required: false
  },
  'dns.op_code': {
    type: 'keyword',
    array: false,
    required: false
  },
  'dns.question.class': {
    type: 'keyword',
    array: false,
    required: false
  },
  'dns.question.name': {
    type: 'keyword',
    array: false,
    required: false
  },
  'dns.question.registered_domain': {
    type: 'keyword',
    array: false,
    required: false
  },
  'dns.question.subdomain': {
    type: 'keyword',
    array: false,
    required: false
  },
  'dns.question.top_level_domain': {
    type: 'keyword',
    array: false,
    required: false
  },
  'dns.question.type': {
    type: 'keyword',
    array: false,
    required: false
  },
  'dns.resolved_ip': {
    type: 'ip',
    array: true,
    required: false
  },
  'dns.response_code': {
    type: 'keyword',
    array: false,
    required: false
  },
  'dns.type': {
    type: 'keyword',
    array: false,
    required: false
  },
  'ecs.version': {
    type: 'keyword',
    array: false,
    required: true
  },
  'error.code': {
    type: 'keyword',
    array: false,
    required: false
  },
  'error.id': {
    type: 'keyword',
    array: false,
    required: false
  },
  'error.message': {
    type: 'match_only_text',
    array: false,
    required: false
  },
  'error.stack_trace': {
    type: 'wildcard',
    array: false,
    required: false
  },
  'error.type': {
    type: 'keyword',
    array: false,
    required: false
  },
  'event.action': {
    type: 'keyword',
    array: false,
    required: false
  },
  'event.agent_id_status': {
    type: 'keyword',
    array: false,
    required: false
  },
  'event.category': {
    type: 'keyword',
    array: true,
    required: false
  },
  'event.code': {
    type: 'keyword',
    array: false,
    required: false
  },
  'event.created': {
    type: 'date',
    array: false,
    required: false
  },
  'event.dataset': {
    type: 'keyword',
    array: false,
    required: false
  },
  'event.duration': {
    type: 'long',
    array: false,
    required: false
  },
  'event.end': {
    type: 'date',
    array: false,
    required: false
  },
  'event.hash': {
    type: 'keyword',
    array: false,
    required: false
  },
  'event.id': {
    type: 'keyword',
    array: false,
    required: false
  },
  'event.ingested': {
    type: 'date',
    array: false,
    required: false
  },
  'event.kind': {
    type: 'keyword',
    array: false,
    required: false
  },
  'event.module': {
    type: 'keyword',
    array: false,
    required: false
  },
  'event.original': {
    type: 'keyword',
    array: false,
    required: false
  },
  'event.outcome': {
    type: 'keyword',
    array: false,
    required: false
  },
  'event.provider': {
    type: 'keyword',
    array: false,
    required: false
  },
  'event.reason': {
    type: 'keyword',
    array: false,
    required: false
  },
  'event.reference': {
    type: 'keyword',
    array: false,
    required: false
  },
  'event.risk_score': {
    type: 'float',
    array: false,
    required: false
  },
  'event.risk_score_norm': {
    type: 'float',
    array: false,
    required: false
  },
  'event.sequence': {
    type: 'long',
    array: false,
    required: false
  },
  'event.severity': {
    type: 'long',
    array: false,
    required: false
  },
  'event.start': {
    type: 'date',
    array: false,
    required: false
  },
  'event.timezone': {
    type: 'keyword',
    array: false,
    required: false
  },
  'event.type': {
    type: 'keyword',
    array: true,
    required: false
  },
  'event.url': {
    type: 'keyword',
    array: false,
    required: false
  },
  'faas.coldstart': {
    type: 'boolean',
    array: false,
    required: false
  },
  'faas.execution': {
    type: 'keyword',
    array: false,
    required: false
  },
  'faas.trigger': {
    type: 'nested',
    array: false,
    required: false
  },
  'faas.trigger.request_id': {
    type: 'keyword',
    array: false,
    required: false
  },
  'faas.trigger.type': {
    type: 'keyword',
    array: false,
    required: false
  },
  'file.accessed': {
    type: 'date',
    array: false,
    required: false
  },
  'file.attributes': {
    type: 'keyword',
    array: true,
    required: false
  },
  'file.code_signature.digest_algorithm': {
    type: 'keyword',
    array: false,
    required: false
  },
  'file.code_signature.exists': {
    type: 'boolean',
    array: false,
    required: false
  },
  'file.code_signature.signing_id': {
    type: 'keyword',
    array: false,
    required: false
  },
  'file.code_signature.status': {
    type: 'keyword',
    array: false,
    required: false
  },
  'file.code_signature.subject_name': {
    type: 'keyword',
    array: false,
    required: false
  },
  'file.code_signature.team_id': {
    type: 'keyword',
    array: false,
    required: false
  },
  'file.code_signature.timestamp': {
    type: 'date',
    array: false,
    required: false
  },
  'file.code_signature.trusted': {
    type: 'boolean',
    array: false,
    required: false
  },
  'file.code_signature.valid': {
    type: 'boolean',
    array: false,
    required: false
  },
  'file.created': {
    type: 'date',
    array: false,
    required: false
  },
  'file.ctime': {
    type: 'date',
    array: false,
    required: false
  },
  'file.device': {
    type: 'keyword',
    array: false,
    required: false
  },
  'file.directory': {
    type: 'keyword',
    array: false,
    required: false
  },
  'file.drive_letter': {
    type: 'keyword',
    array: false,
    required: false
  },
  'file.elf.architecture': {
    type: 'keyword',
    array: false,
    required: false
  },
  'file.elf.byte_order': {
    type: 'keyword',
    array: false,
    required: false
  },
  'file.elf.cpu_type': {
    type: 'keyword',
    array: false,
    required: false
  },
  'file.elf.creation_date': {
    type: 'date',
    array: false,
    required: false
  },
  'file.elf.exports': {
    type: 'flattened',
    array: true,
    required: false
  },
  'file.elf.header.abi_version': {
    type: 'keyword',
    array: false,
    required: false
  },
  'file.elf.header.class': {
    type: 'keyword',
    array: false,
    required: false
  },
  'file.elf.header.data': {
    type: 'keyword',
    array: false,
    required: false
  },
  'file.elf.header.entrypoint': {
    type: 'long',
    array: false,
    required: false
  },
  'file.elf.header.object_version': {
    type: 'keyword',
    array: false,
    required: false
  },
  'file.elf.header.os_abi': {
    type: 'keyword',
    array: false,
    required: false
  },
  'file.elf.header.type': {
    type: 'keyword',
    array: false,
    required: false
  },
  'file.elf.header.version': {
    type: 'keyword',
    array: false,
    required: false
  },
  'file.elf.imports': {
    type: 'flattened',
    array: true,
    required: false
  },
  'file.elf.sections': {
    type: 'nested',
    array: true,
    required: false
  },
  'file.elf.sections.chi2': {
    type: 'long',
    array: false,
    required: false
  },
  'file.elf.sections.entropy': {
    type: 'long',
    array: false,
    required: false
  },
  'file.elf.sections.flags': {
    type: 'keyword',
    array: false,
    required: false
  },
  'file.elf.sections.name': {
    type: 'keyword',
    array: false,
    required: false
  },
  'file.elf.sections.physical_offset': {
    type: 'keyword',
    array: false,
    required: false
  },
  'file.elf.sections.physical_size': {
    type: 'long',
    array: false,
    required: false
  },
  'file.elf.sections.type': {
    type: 'keyword',
    array: false,
    required: false
  },
  'file.elf.sections.virtual_address': {
    type: 'long',
    array: false,
    required: false
  },
  'file.elf.sections.virtual_size': {
    type: 'long',
    array: false,
    required: false
  },
  'file.elf.segments': {
    type: 'nested',
    array: true,
    required: false
  },
  'file.elf.segments.sections': {
    type: 'keyword',
    array: false,
    required: false
  },
  'file.elf.segments.type': {
    type: 'keyword',
    array: false,
    required: false
  },
  'file.elf.shared_libraries': {
    type: 'keyword',
    array: true,
    required: false
  },
  'file.elf.telfhash': {
    type: 'keyword',
    array: false,
    required: false
  },
  'file.extension': {
    type: 'keyword',
    array: false,
    required: false
  },
  'file.fork_name': {
    type: 'keyword',
    array: false,
    required: false
  },
  'file.gid': {
    type: 'keyword',
    array: false,
    required: false
  },
  'file.group': {
    type: 'keyword',
    array: false,
    required: false
  },
  'file.hash.md5': {
    type: 'keyword',
    array: false,
    required: false
  },
  'file.hash.sha1': {
    type: 'keyword',
    array: false,
    required: false
  },
  'file.hash.sha256': {
    type: 'keyword',
    array: false,
    required: false
  },
  'file.hash.sha512': {
    type: 'keyword',
    array: false,
    required: false
  },
  'file.hash.ssdeep': {
    type: 'keyword',
    array: false,
    required: false
  },
  'file.inode': {
    type: 'keyword',
    array: false,
    required: false
  },
  'file.mime_type': {
    type: 'keyword',
    array: false,
    required: false
  },
  'file.mode': {
    type: 'keyword',
    array: false,
    required: false
  },
  'file.mtime': {
    type: 'date',
    array: false,
    required: false
  },
  'file.name': {
    type: 'keyword',
    array: false,
    required: false
  },
  'file.owner': {
    type: 'keyword',
    array: false,
    required: false
  },
  'file.path': {
    type: 'keyword',
    array: false,
    required: false
  },
  'file.pe.architecture': {
    type: 'keyword',
    array: false,
    required: false
  },
  'file.pe.company': {
    type: 'keyword',
    array: false,
    required: false
  },
  'file.pe.description': {
    type: 'keyword',
    array: false,
    required: false
  },
  'file.pe.file_version': {
    type: 'keyword',
    array: false,
    required: false
  },
  'file.pe.imphash': {
    type: 'keyword',
    array: false,
    required: false
  },
  'file.pe.original_file_name': {
    type: 'keyword',
    array: false,
    required: false
  },
  'file.pe.product': {
    type: 'keyword',
    array: false,
    required: false
  },
  'file.size': {
    type: 'long',
    array: false,
    required: false
  },
  'file.target_path': {
    type: 'keyword',
    array: false,
    required: false
  },
  'file.type': {
    type: 'keyword',
    array: false,
    required: false
  },
  'file.uid': {
    type: 'keyword',
    array: false,
    required: false
  },
  'file.x509.alternative_names': {
    type: 'keyword',
    array: true,
    required: false
  },
  'file.x509.issuer.common_name': {
    type: 'keyword',
    array: true,
    required: false
  },
  'file.x509.issuer.country': {
    type: 'keyword',
    array: true,
    required: false
  },
  'file.x509.issuer.distinguished_name': {
    type: 'keyword',
    array: false,
    required: false
  },
  'file.x509.issuer.locality': {
    type: 'keyword',
    array: true,
    required: false
  },
  'file.x509.issuer.organization': {
    type: 'keyword',
    array: true,
    required: false
  },
  'file.x509.issuer.organizational_unit': {
    type: 'keyword',
    array: true,
    required: false
  },
  'file.x509.issuer.state_or_province': {
    type: 'keyword',
    array: true,
    required: false
  },
  'file.x509.not_after': {
    type: 'date',
    array: false,
    required: false
  },
  'file.x509.not_before': {
    type: 'date',
    array: false,
    required: false
  },
  'file.x509.public_key_algorithm': {
    type: 'keyword',
    array: false,
    required: false
  },
  'file.x509.public_key_curve': {
    type: 'keyword',
    array: false,
    required: false
  },
  'file.x509.public_key_exponent': {
    type: 'long',
    array: false,
    required: false
  },
  'file.x509.public_key_size': {
    type: 'long',
    array: false,
    required: false
  },
  'file.x509.serial_number': {
    type: 'keyword',
    array: false,
    required: false
  },
  'file.x509.signature_algorithm': {
    type: 'keyword',
    array: false,
    required: false
  },
  'file.x509.subject.common_name': {
    type: 'keyword',
    array: true,
    required: false
  },
  'file.x509.subject.country': {
    type: 'keyword',
    array: true,
    required: false
  },
  'file.x509.subject.distinguished_name': {
    type: 'keyword',
    array: false,
    required: false
  },
  'file.x509.subject.locality': {
    type: 'keyword',
    array: true,
    required: false
  },
  'file.x509.subject.organization': {
    type: 'keyword',
    array: true,
    required: false
  },
  'file.x509.subject.organizational_unit': {
    type: 'keyword',
    array: true,
    required: false
  },
  'file.x509.subject.state_or_province': {
    type: 'keyword',
    array: true,
    required: false
  },
  'file.x509.version_number': {
    type: 'keyword',
    array: false,
    required: false
  },
  'group.domain': {
    type: 'keyword',
    array: false,
    required: false
  },
  'group.id': {
    type: 'keyword',
    array: false,
    required: false
  },
  'group.name': {
    type: 'keyword',
    array: false,
    required: false
  },
  'host.architecture': {
    type: 'keyword',
    array: false,
    required: false
  },
  'host.boot.id': {
    type: 'keyword',
    array: false,
    required: false
  },
  'host.cpu.usage': {
    type: 'scaled_float',
    array: false,
    required: false,
    scaling_factor: 1000
  },
  'host.disk.read.bytes': {
    type: 'long',
    array: false,
    required: false
  },
  'host.disk.write.bytes': {
    type: 'long',
    array: false,
    required: false
  },
  'host.domain': {
    type: 'keyword',
    array: false,
    required: false
  },
  'host.geo.city_name': {
    type: 'keyword',
    array: false,
    required: false
  },
  'host.geo.continent_code': {
    type: 'keyword',
    array: false,
    required: false
  },
  'host.geo.continent_name': {
    type: 'keyword',
    array: false,
    required: false
  },
  'host.geo.country_iso_code': {
    type: 'keyword',
    array: false,
    required: false
  },
  'host.geo.country_name': {
    type: 'keyword',
    array: false,
    required: false
  },
  'host.geo.location': {
    type: 'geo_point',
    array: false,
    required: false
  },
  'host.geo.name': {
    type: 'keyword',
    array: false,
    required: false
  },
  'host.geo.postal_code': {
    type: 'keyword',
    array: false,
    required: false
  },
  'host.geo.region_iso_code': {
    type: 'keyword',
    array: false,
    required: false
  },
  'host.geo.region_name': {
    type: 'keyword',
    array: false,
    required: false
  },
  'host.geo.timezone': {
    type: 'keyword',
    array: false,
    required: false
  },
  'host.hostname': {
    type: 'keyword',
    array: false,
    required: false
  },
  'host.id': {
    type: 'keyword',
    array: false,
    required: false
  },
  'host.ip': {
    type: 'ip',
    array: true,
    required: false
  },
  'host.mac': {
    type: 'keyword',
    array: true,
    required: false
  },
  'host.name': {
    type: 'keyword',
    array: false,
    required: false
  },
  'host.network.egress.bytes': {
    type: 'long',
    array: false,
    required: false
  },
  'host.network.egress.packets': {
    type: 'long',
    array: false,
    required: false
  },
  'host.network.ingress.bytes': {
    type: 'long',
    array: false,
    required: false
  },
  'host.network.ingress.packets': {
    type: 'long',
    array: false,
    required: false
  },
  'host.os.family': {
    type: 'keyword',
    array: false,
    required: false
  },
  'host.os.full': {
    type: 'keyword',
    array: false,
    required: false
  },
  'host.os.kernel': {
    type: 'keyword',
    array: false,
    required: false
  },
  'host.os.name': {
    type: 'keyword',
    array: false,
    required: false
  },
  'host.os.platform': {
    type: 'keyword',
    array: false,
    required: false
  },
  'host.os.type': {
    type: 'keyword',
    array: false,
    required: false
  },
  'host.os.version': {
    type: 'keyword',
    array: false,
    required: false
  },
  'host.pid_ns_ino': {
    type: 'keyword',
    array: false,
    required: false
  },
  'host.risk.calculated_level': {
    type: 'keyword',
    array: false,
    required: false
  },
  'host.risk.calculated_score': {
    type: 'float',
    array: false,
    required: false
  },
  'host.risk.calculated_score_norm': {
    type: 'float',
    array: false,
    required: false
  },
  'host.risk.static_level': {
    type: 'keyword',
    array: false,
    required: false
  },
  'host.risk.static_score': {
    type: 'float',
    array: false,
    required: false
  },
  'host.risk.static_score_norm': {
    type: 'float',
    array: false,
    required: false
  },
  'host.type': {
    type: 'keyword',
    array: false,
    required: false
  },
  'host.uptime': {
    type: 'long',
    array: false,
    required: false
  },
  'http.request.body.bytes': {
    type: 'long',
    array: false,
    required: false
  },
  'http.request.body.content': {
    type: 'wildcard',
    array: false,
    required: false
  },
  'http.request.bytes': {
    type: 'long',
    array: false,
    required: false
  },
  'http.request.id': {
    type: 'keyword',
    array: false,
    required: false
  },
  'http.request.method': {
    type: 'keyword',
    array: false,
    required: false
  },
  'http.request.mime_type': {
    type: 'keyword',
    array: false,
    required: false
  },
  'http.request.referrer': {
    type: 'keyword',
    array: false,
    required: false
  },
  'http.response.body.bytes': {
    type: 'long',
    array: false,
    required: false
  },
  'http.response.body.content': {
    type: 'wildcard',
    array: false,
    required: false
  },
  'http.response.bytes': {
    type: 'long',
    array: false,
    required: false
  },
  'http.response.mime_type': {
    type: 'keyword',
    array: false,
    required: false
  },
  'http.response.status_code': {
    type: 'long',
    array: false,
    required: false
  },
  'http.version': {
    type: 'keyword',
    array: false,
    required: false
  },
  labels: {
    type: 'object',
    array: false,
    required: false
  },
  'log.file.path': {
    type: 'keyword',
    array: false,
    required: false
  },
  'log.level': {
    type: 'keyword',
    array: false,
    required: false
  },
  'log.logger': {
    type: 'keyword',
    array: false,
    required: false
  },
  'log.origin.file.line': {
    type: 'long',
    array: false,
    required: false
  },
  'log.origin.file.name': {
    type: 'keyword',
    array: false,
    required: false
  },
  'log.origin.function': {
    type: 'keyword',
    array: false,
    required: false
  },
  'log.syslog': {
    type: 'object',
    array: false,
    required: false
  },
  'log.syslog.facility.code': {
    type: 'long',
    array: false,
    required: false
  },
  'log.syslog.facility.name': {
    type: 'keyword',
    array: false,
    required: false
  },
  'log.syslog.priority': {
    type: 'long',
    array: false,
    required: false
  },
  'log.syslog.severity.code': {
    type: 'long',
    array: false,
    required: false
  },
  'log.syslog.severity.name': {
    type: 'keyword',
    array: false,
    required: false
  },
  message: {
    type: 'match_only_text',
    array: false,
    required: false
  },
  'network.application': {
    type: 'keyword',
    array: false,
    required: false
  },
  'network.bytes': {
    type: 'long',
    array: false,
    required: false
  },
  'network.community_id': {
    type: 'keyword',
    array: false,
    required: false
  },
  'network.direction': {
    type: 'keyword',
    array: false,
    required: false
  },
  'network.forwarded_ip': {
    type: 'ip',
    array: false,
    required: false
  },
  'network.iana_number': {
    type: 'keyword',
    array: false,
    required: false
  },
  'network.inner': {
    type: 'object',
    array: false,
    required: false
  },
  'network.inner.vlan.id': {
    type: 'keyword',
    array: false,
    required: false
  },
  'network.inner.vlan.name': {
    type: 'keyword',
    array: false,
    required: false
  },
  'network.name': {
    type: 'keyword',
    array: false,
    required: false
  },
  'network.packets': {
    type: 'long',
    array: false,
    required: false
  },
  'network.protocol': {
    type: 'keyword',
    array: false,
    required: false
  },
  'network.transport': {
    type: 'keyword',
    array: false,
    required: false
  },
  'network.type': {
    type: 'keyword',
    array: false,
    required: false
  },
  'network.vlan.id': {
    type: 'keyword',
    array: false,
    required: false
  },
  'network.vlan.name': {
    type: 'keyword',
    array: false,
    required: false
  },
  'observer.egress': {
    type: 'object',
    array: false,
    required: false
  },
  'observer.egress.interface.alias': {
    type: 'keyword',
    array: false,
    required: false
  },
  'observer.egress.interface.id': {
    type: 'keyword',
    array: false,
    required: false
  },
  'observer.egress.interface.name': {
    type: 'keyword',
    array: false,
    required: false
  },
  'observer.egress.vlan.id': {
    type: 'keyword',
    array: false,
    required: false
  },
  'observer.egress.vlan.name': {
    type: 'keyword',
    array: false,
    required: false
  },
  'observer.egress.zone': {
    type: 'keyword',
    array: false,
    required: false
  },
  'observer.geo.city_name': {
    type: 'keyword',
    array: false,
    required: false
  },
  'observer.geo.continent_code': {
    type: 'keyword',
    array: false,
    required: false
  },
  'observer.geo.continent_name': {
    type: 'keyword',
    array: false,
    required: false
  },
  'observer.geo.country_iso_code': {
    type: 'keyword',
    array: false,
    required: false
  },
  'observer.geo.country_name': {
    type: 'keyword',
    array: false,
    required: false
  },
  'observer.geo.location': {
    type: 'geo_point',
    array: false,
    required: false
  },
  'observer.geo.name': {
    type: 'keyword',
    array: false,
    required: false
  },
  'observer.geo.postal_code': {
    type: 'keyword',
    array: false,
    required: false
  },
  'observer.geo.region_iso_code': {
    type: 'keyword',
    array: false,
    required: false
  },
  'observer.geo.region_name': {
    type: 'keyword',
    array: false,
    required: false
  },
  'observer.geo.timezone': {
    type: 'keyword',
    array: false,
    required: false
  },
  'observer.hostname': {
    type: 'keyword',
    array: false,
    required: false
  },
  'observer.ingress': {
    type: 'object',
    array: false,
    required: false
  },
  'observer.ingress.interface.alias': {
    type: 'keyword',
    array: false,
    required: false
  },
  'observer.ingress.interface.id': {
    type: 'keyword',
    array: false,
    required: false
  },
  'observer.ingress.interface.name': {
    type: 'keyword',
    array: false,
    required: false
  },
  'observer.ingress.vlan.id': {
    type: 'keyword',
    array: false,
    required: false
  },
  'observer.ingress.vlan.name': {
    type: 'keyword',
    array: false,
    required: false
  },
  'observer.ingress.zone': {
    type: 'keyword',
    array: false,
    required: false
  },
  'observer.ip': {
    type: 'ip',
    array: true,
    required: false
  },
  'observer.mac': {
    type: 'keyword',
    array: true,
    required: false
  },
  'observer.name': {
    type: 'keyword',
    array: false,
    required: false
  },
  'observer.os.family': {
    type: 'keyword',
    array: false,
    required: false
  },
  'observer.os.full': {
    type: 'keyword',
    array: false,
    required: false
  },
  'observer.os.kernel': {
    type: 'keyword',
    array: false,
    required: false
  },
  'observer.os.name': {
    type: 'keyword',
    array: false,
    required: false
  },
  'observer.os.platform': {
    type: 'keyword',
    array: false,
    required: false
  },
  'observer.os.type': {
    type: 'keyword',
    array: false,
    required: false
  },
  'observer.os.version': {
    type: 'keyword',
    array: false,
    required: false
  },
  'observer.product': {
    type: 'keyword',
    array: false,
    required: false
  },
  'observer.serial_number': {
    type: 'keyword',
    array: false,
    required: false
  },
  'observer.type': {
    type: 'keyword',
    array: false,
    required: false
  },
  'observer.vendor': {
    type: 'keyword',
    array: false,
    required: false
  },
  'observer.version': {
    type: 'keyword',
    array: false,
    required: false
  },
  'orchestrator.api_version': {
    type: 'keyword',
    array: false,
    required: false
  },
  'orchestrator.cluster.id': {
    type: 'keyword',
    array: false,
    required: false
  },
  'orchestrator.cluster.name': {
    type: 'keyword',
    array: false,
    required: false
  },
  'orchestrator.cluster.url': {
    type: 'keyword',
    array: false,
    required: false
  },
  'orchestrator.cluster.version': {
    type: 'keyword',
    array: false,
    required: false
  },
  'orchestrator.namespace': {
    type: 'keyword',
    array: false,
    required: false
  },
  'orchestrator.organization': {
    type: 'keyword',
    array: false,
    required: false
  },
  'orchestrator.resource.id': {
    type: 'keyword',
    array: false,
    required: false
  },
  'orchestrator.resource.ip': {
    type: 'ip',
    array: true,
    required: false
  },
  'orchestrator.resource.name': {
    type: 'keyword',
    array: false,
    required: false
  },
  'orchestrator.resource.parent.type': {
    type: 'keyword',
    array: false,
    required: false
  },
  'orchestrator.resource.type': {
    type: 'keyword',
    array: false,
    required: false
  },
  'orchestrator.type': {
    type: 'keyword',
    array: false,
    required: false
  },
  'organization.id': {
    type: 'keyword',
    array: false,
    required: false
  },
  'organization.name': {
    type: 'keyword',
    array: false,
    required: false
  },
  'package.architecture': {
    type: 'keyword',
    array: false,
    required: false
  },
  'package.build_version': {
    type: 'keyword',
    array: false,
    required: false
  },
  'package.checksum': {
    type: 'keyword',
    array: false,
    required: false
  },
  'package.description': {
    type: 'keyword',
    array: false,
    required: false
  },
  'package.install_scope': {
    type: 'keyword',
    array: false,
    required: false
  },
  'package.installed': {
    type: 'date',
    array: false,
    required: false
  },
  'package.license': {
    type: 'keyword',
    array: false,
    required: false
  },
  'package.name': {
    type: 'keyword',
    array: false,
    required: false
  },
  'package.path': {
    type: 'keyword',
    array: false,
    required: false
  },
  'package.reference': {
    type: 'keyword',
    array: false,
    required: false
  },
  'package.size': {
    type: 'long',
    array: false,
    required: false
  },
  'package.type': {
    type: 'keyword',
    array: false,
    required: false
  },
  'package.version': {
    type: 'keyword',
    array: false,
    required: false
  },
  'process.args': {
    type: 'keyword',
    array: true,
    required: false
  },
  'process.args_count': {
    type: 'long',
    array: false,
    required: false
  },
  'process.code_signature.digest_algorithm': {
    type: 'keyword',
    array: false,
    required: false
  },
  'process.code_signature.exists': {
    type: 'boolean',
    array: false,
    required: false
  },
  'process.code_signature.signing_id': {
    type: 'keyword',
    array: false,
    required: false
  },
  'process.code_signature.status': {
    type: 'keyword',
    array: false,
    required: false
  },
  'process.code_signature.subject_name': {
    type: 'keyword',
    array: false,
    required: false
  },
  'process.code_signature.team_id': {
    type: 'keyword',
    array: false,
    required: false
  },
  'process.code_signature.timestamp': {
    type: 'date',
    array: false,
    required: false
  },
  'process.code_signature.trusted': {
    type: 'boolean',
    array: false,
    required: false
  },
  'process.code_signature.valid': {
    type: 'boolean',
    array: false,
    required: false
  },
  'process.command_line': {
    type: 'wildcard',
    array: false,
    required: false
  },
  'process.elf.architecture': {
    type: 'keyword',
    array: false,
    required: false
  },
  'process.elf.byte_order': {
    type: 'keyword',
    array: false,
    required: false
  },
  'process.elf.cpu_type': {
    type: 'keyword',
    array: false,
    required: false
  },
  'process.elf.creation_date': {
    type: 'date',
    array: false,
    required: false
  },
  'process.elf.exports': {
    type: 'flattened',
    array: true,
    required: false
  },
  'process.elf.header.abi_version': {
    type: 'keyword',
    array: false,
    required: false
  },
  'process.elf.header.class': {
    type: 'keyword',
    array: false,
    required: false
  },
  'process.elf.header.data': {
    type: 'keyword',
    array: false,
    required: false
  },
  'process.elf.header.entrypoint': {
    type: 'long',
    array: false,
    required: false
  },
  'process.elf.header.object_version': {
    type: 'keyword',
    array: false,
    required: false
  },
  'process.elf.header.os_abi': {
    type: 'keyword',
    array: false,
    required: false
  },
  'process.elf.header.type': {
    type: 'keyword',
    array: false,
    required: false
  },
  'process.elf.header.version': {
    type: 'keyword',
    array: false,
    required: false
  },
  'process.elf.imports': {
    type: 'flattened',
    array: true,
    required: false
  },
  'process.elf.sections': {
    type: 'nested',
    array: true,
    required: false
  },
  'process.elf.sections.chi2': {
    type: 'long',
    array: false,
    required: false
  },
  'process.elf.sections.entropy': {
    type: 'long',
    array: false,
    required: false
  },
  'process.elf.sections.flags': {
    type: 'keyword',
    array: false,
    required: false
  },
  'process.elf.sections.name': {
    type: 'keyword',
    array: false,
    required: false
  },
  'process.elf.sections.physical_offset': {
    type: 'keyword',
    array: false,
    required: false
  },
  'process.elf.sections.physical_size': {
    type: 'long',
    array: false,
    required: false
  },
  'process.elf.sections.type': {
    type: 'keyword',
    array: false,
    required: false
  },
  'process.elf.sections.virtual_address': {
    type: 'long',
    array: false,
    required: false
  },
  'process.elf.sections.virtual_size': {
    type: 'long',
    array: false,
    required: false
  },
  'process.elf.segments': {
    type: 'nested',
    array: true,
    required: false
  },
  'process.elf.segments.sections': {
    type: 'keyword',
    array: false,
    required: false
  },
  'process.elf.segments.type': {
    type: 'keyword',
    array: false,
    required: false
  },
  'process.elf.shared_libraries': {
    type: 'keyword',
    array: true,
    required: false
  },
  'process.elf.telfhash': {
    type: 'keyword',
    array: false,
    required: false
  },
  'process.end': {
    type: 'date',
    array: false,
    required: false
  },
  'process.entity_id': {
    type: 'keyword',
    array: false,
    required: false
  },
  'process.entry_leader.entity_id': {
    type: 'keyword',
    array: false,
    required: false
  },
  'process.executable': {
    type: 'keyword',
    array: false,
    required: false
  },
  'process.exit_code': {
    type: 'long',
    array: false,
    required: false
  },
  'process.hash.md5': {
    type: 'keyword',
    array: false,
    required: false
  },
  'process.hash.sha1': {
    type: 'keyword',
    array: false,
    required: false
  },
  'process.hash.sha256': {
    type: 'keyword',
    array: false,
    required: false
  },
  'process.hash.sha512': {
    type: 'keyword',
    array: false,
    required: false
  },
  'process.hash.ssdeep': {
    type: 'keyword',
    array: false,
    required: false
  },
  'process.name': {
    type: 'keyword',
    array: false,
    required: false
  },
  'process.parent.args': {
    type: 'keyword',
    array: true,
    required: false
  },
  'process.parent.args_count': {
    type: 'long',
    array: false,
    required: false
  },
  'process.parent.code_signature.digest_algorithm': {
    type: 'keyword',
    array: false,
    required: false
  },
  'process.parent.code_signature.exists': {
    type: 'boolean',
    array: false,
    required: false
  },
  'process.parent.code_signature.signing_id': {
    type: 'keyword',
    array: false,
    required: false
  },
  'process.parent.code_signature.status': {
    type: 'keyword',
    array: false,
    required: false
  },
  'process.parent.code_signature.subject_name': {
    type: 'keyword',
    array: false,
    required: false
  },
  'process.parent.code_signature.team_id': {
    type: 'keyword',
    array: false,
    required: false
  },
  'process.parent.code_signature.timestamp': {
    type: 'date',
    array: false,
    required: false
  },
  'process.parent.code_signature.trusted': {
    type: 'boolean',
    array: false,
    required: false
  },
  'process.parent.code_signature.valid': {
    type: 'boolean',
    array: false,
    required: false
  },
  'process.parent.command_line': {
    type: 'wildcard',
    array: false,
    required: false
  },
  'process.parent.elf.architecture': {
    type: 'keyword',
    array: false,
    required: false
  },
  'process.parent.elf.byte_order': {
    type: 'keyword',
    array: false,
    required: false
  },
  'process.parent.elf.cpu_type': {
    type: 'keyword',
    array: false,
    required: false
  },
  'process.parent.elf.creation_date': {
    type: 'date',
    array: false,
    required: false
  },
  'process.parent.elf.exports': {
    type: 'flattened',
    array: true,
    required: false
  },
  'process.parent.elf.header.abi_version': {
    type: 'keyword',
    array: false,
    required: false
  },
  'process.parent.elf.header.class': {
    type: 'keyword',
    array: false,
    required: false
  },
  'process.parent.elf.header.data': {
    type: 'keyword',
    array: false,
    required: false
  },
  'process.parent.elf.header.entrypoint': {
    type: 'long',
    array: false,
    required: false
  },
  'process.parent.elf.header.object_version': {
    type: 'keyword',
    array: false,
    required: false
  },
  'process.parent.elf.header.os_abi': {
    type: 'keyword',
    array: false,
    required: false
  },
  'process.parent.elf.header.type': {
    type: 'keyword',
    array: false,
    required: false
  },
  'process.parent.elf.header.version': {
    type: 'keyword',
    array: false,
    required: false
  },
  'process.parent.elf.imports': {
    type: 'flattened',
    array: true,
    required: false
  },
  'process.parent.elf.sections': {
    type: 'nested',
    array: true,
    required: false
  },
  'process.parent.elf.sections.chi2': {
    type: 'long',
    array: false,
    required: false
  },
  'process.parent.elf.sections.entropy': {
    type: 'long',
    array: false,
    required: false
  },
  'process.parent.elf.sections.flags': {
    type: 'keyword',
    array: false,
    required: false
  },
  'process.parent.elf.sections.name': {
    type: 'keyword',
    array: false,
    required: false
  },
  'process.parent.elf.sections.physical_offset': {
    type: 'keyword',
    array: false,
    required: false
  },
  'process.parent.elf.sections.physical_size': {
    type: 'long',
    array: false,
    required: false
  },
  'process.parent.elf.sections.type': {
    type: 'keyword',
    array: false,
    required: false
  },
  'process.parent.elf.sections.virtual_address': {
    type: 'long',
    array: false,
    required: false
  },
  'process.parent.elf.sections.virtual_size': {
    type: 'long',
    array: false,
    required: false
  },
  'process.parent.elf.segments': {
    type: 'nested',
    array: true,
    required: false
  },
  'process.parent.elf.segments.sections': {
    type: 'keyword',
    array: false,
    required: false
  },
  'process.parent.elf.segments.type': {
    type: 'keyword',
    array: false,
    required: false
  },
  'process.parent.elf.shared_libraries': {
    type: 'keyword',
    array: true,
    required: false
  },
  'process.parent.elf.telfhash': {
    type: 'keyword',
    array: false,
    required: false
  },
  'process.parent.end': {
    type: 'date',
    array: false,
    required: false
  },
  'process.parent.entity_id': {
    type: 'keyword',
    array: false,
    required: false
  },
  'process.parent.executable': {
    type: 'keyword',
    array: false,
    required: false
  },
  'process.parent.exit_code': {
    type: 'long',
    array: false,
    required: false
  },
  'process.parent.hash.md5': {
    type: 'keyword',
    array: false,
    required: false
  },
  'process.parent.hash.sha1': {
    type: 'keyword',
    array: false,
    required: false
  },
  'process.parent.hash.sha256': {
    type: 'keyword',
    array: false,
    required: false
  },
  'process.parent.hash.sha512': {
    type: 'keyword',
    array: false,
    required: false
  },
  'process.parent.hash.ssdeep': {
    type: 'keyword',
    array: false,
    required: false
  },
  'process.parent.name': {
    type: 'keyword',
    array: false,
    required: false
  },
  'process.parent.pe.architecture': {
    type: 'keyword',
    array: false,
    required: false
  },
  'process.parent.pe.company': {
    type: 'keyword',
    array: false,
    required: false
  },
  'process.parent.pe.description': {
    type: 'keyword',
    array: false,
    required: false
  },
  'process.parent.pe.file_version': {
    type: 'keyword',
    array: false,
    required: false
  },
  'process.parent.pe.imphash': {
    type: 'keyword',
    array: false,
    required: false
  },
  'process.parent.pe.original_file_name': {
    type: 'keyword',
    array: false,
    required: false
  },
  'process.parent.pe.product': {
    type: 'keyword',
    array: false,
    required: false
  },
  'process.parent.pgid': {
    type: 'long',
    array: false,
    required: false
  },
  'process.parent.pid': {
    type: 'long',
    array: false,
    required: false
  },
  'process.parent.start': {
    type: 'date',
    array: false,
    required: false
  },
  'process.parent.thread.id': {
    type: 'long',
    array: false,
    required: false
  },
  'process.parent.thread.name': {
    type: 'keyword',
    array: false,
    required: false
  },
  'process.parent.title': {
    type: 'keyword',
    array: false,
    required: false
  },
  'process.parent.uptime': {
    type: 'long',
    array: false,
    required: false
  },
  'process.parent.working_directory': {
    type: 'keyword',
    array: false,
    required: false
  },
  'process.pe.architecture': {
    type: 'keyword',
    array: false,
    required: false
  },
  'process.pe.company': {
    type: 'keyword',
    array: false,
    required: false
  },
  'process.pe.description': {
    type: 'keyword',
    array: false,
    required: false
  },
  'process.pe.file_version': {
    type: 'keyword',
    array: false,
    required: false
  },
  'process.pe.imphash': {
    type: 'keyword',
    array: false,
    required: false
  },
  'process.pe.original_file_name': {
    type: 'keyword',
    array: false,
    required: false
  },
  'process.pe.product': {
    type: 'keyword',
    array: false,
    required: false
  },
  'process.pgid': {
    type: 'long',
    array: false,
    required: false
  },
  'process.pid': {
    type: 'long',
    array: false,
    required: false
  },
  'process.session_leader.entity_id': {
    type: 'keyword',
    array: false,
    required: false
  },
  'process.start': {
    type: 'date',
    array: false,
    required: false
  },
  'process.thread.id': {
    type: 'long',
    array: false,
    required: false
  },
  'process.thread.name': {
    type: 'keyword',
    array: false,
    required: false
  },
  'process.title': {
    type: 'keyword',
    array: false,
    required: false
  },
  'process.uptime': {
    type: 'long',
    array: false,
    required: false
  },
  'process.working_directory': {
    type: 'keyword',
    array: false,
    required: false
  },
  'registry.data.bytes': {
    type: 'keyword',
    array: false,
    required: false
  },
  'registry.data.strings': {
    type: 'wildcard',
    array: true,
    required: false
  },
  'registry.data.type': {
    type: 'keyword',
    array: false,
    required: false
  },
  'registry.hive': {
    type: 'keyword',
    array: false,
    required: false
  },
  'registry.key': {
    type: 'keyword',
    array: false,
    required: false
  },
  'registry.path': {
    type: 'keyword',
    array: false,
    required: false
  },
  'registry.value': {
    type: 'keyword',
    array: false,
    required: false
  },
  'related.hash': {
    type: 'keyword',
    array: true,
    required: false
  },
  'related.hosts': {
    type: 'keyword',
    array: true,
    required: false
  },
  'related.ip': {
    type: 'ip',
    array: true,
    required: false
  },
  'related.user': {
    type: 'keyword',
    array: true,
    required: false
  },
  'rule.author': {
    type: 'keyword',
    array: true,
    required: false
  },
  'rule.category': {
    type: 'keyword',
    array: false,
    required: false
  },
  'rule.description': {
    type: 'keyword',
    array: false,
    required: false
  },
  'rule.id': {
    type: 'keyword',
    array: false,
    required: false
  },
  'rule.license': {
    type: 'keyword',
    array: false,
    required: false
  },
  'rule.name': {
    type: 'keyword',
    array: false,
    required: false
  },
  'rule.reference': {
    type: 'keyword',
    array: false,
    required: false
  },
  'rule.ruleset': {
    type: 'keyword',
    array: false,
    required: false
  },
  'rule.uuid': {
    type: 'keyword',
    array: false,
    required: false
  },
  'rule.version': {
    type: 'keyword',
    array: false,
    required: false
  },
  'server.address': {
    type: 'keyword',
    array: false,
    required: false
  },
  'server.as.number': {
    type: 'long',
    array: false,
    required: false
  },
  'server.as.organization.name': {
    type: 'keyword',
    array: false,
    required: false
  },
  'server.bytes': {
    type: 'long',
    array: false,
    required: false
  },
  'server.domain': {
    type: 'keyword',
    array: false,
    required: false
  },
  'server.geo.city_name': {
    type: 'keyword',
    array: false,
    required: false
  },
  'server.geo.continent_code': {
    type: 'keyword',
    array: false,
    required: false
  },
  'server.geo.continent_name': {
    type: 'keyword',
    array: false,
    required: false
  },
  'server.geo.country_iso_code': {
    type: 'keyword',
    array: false,
    required: false
  },
  'server.geo.country_name': {
    type: 'keyword',
    array: false,
    required: false
  },
  'server.geo.location': {
    type: 'geo_point',
    array: false,
    required: false
  },
  'server.geo.name': {
    type: 'keyword',
    array: false,
    required: false
  },
  'server.geo.postal_code': {
    type: 'keyword',
    array: false,
    required: false
  },
  'server.geo.region_iso_code': {
    type: 'keyword',
    array: false,
    required: false
  },
  'server.geo.region_name': {
    type: 'keyword',
    array: false,
    required: false
  },
  'server.geo.timezone': {
    type: 'keyword',
    array: false,
    required: false
  },
  'server.ip': {
    type: 'ip',
    array: false,
    required: false
  },
  'server.mac': {
    type: 'keyword',
    array: false,
    required: false
  },
  'server.nat.ip': {
    type: 'ip',
    array: false,
    required: false
  },
  'server.nat.port': {
    type: 'long',
    array: false,
    required: false
  },
  'server.packets': {
    type: 'long',
    array: false,
    required: false
  },
  'server.port': {
    type: 'long',
    array: false,
    required: false
  },
  'server.registered_domain': {
    type: 'keyword',
    array: false,
    required: false
  },
  'server.subdomain': {
    type: 'keyword',
    array: false,
    required: false
  },
  'server.top_level_domain': {
    type: 'keyword',
    array: false,
    required: false
  },
  'server.user.domain': {
    type: 'keyword',
    array: false,
    required: false
  },
  'server.user.email': {
    type: 'keyword',
    array: false,
    required: false
  },
  'server.user.full_name': {
    type: 'keyword',
    array: false,
    required: false
  },
  'server.user.group.domain': {
    type: 'keyword',
    array: false,
    required: false
  },
  'server.user.group.id': {
    type: 'keyword',
    array: false,
    required: false
  },
  'server.user.group.name': {
    type: 'keyword',
    array: false,
    required: false
  },
  'server.user.hash': {
    type: 'keyword',
    array: false,
    required: false
  },
  'server.user.id': {
    type: 'keyword',
    array: false,
    required: false
  },
  'server.user.name': {
    type: 'keyword',
    array: false,
    required: false
  },
  'server.user.roles': {
    type: 'keyword',
    array: true,
    required: false
  },
  'service.address': {
    type: 'keyword',
    array: false,
    required: false
  },
  'service.environment': {
    type: 'keyword',
    array: false,
    required: false
  },
  'service.ephemeral_id': {
    type: 'keyword',
    array: false,
    required: false
  },
  'service.id': {
    type: 'keyword',
    array: false,
    required: false
  },
  'service.name': {
    type: 'keyword',
    array: false,
    required: false
  },
  'service.node.name': {
    type: 'keyword',
    array: false,
    required: false
  },
  'service.origin.address': {
    type: 'keyword',
    array: false,
    required: false
  },
  'service.origin.environment': {
    type: 'keyword',
    array: false,
    required: false
  },
  'service.origin.ephemeral_id': {
    type: 'keyword',
    array: false,
    required: false
  },
  'service.origin.id': {
    type: 'keyword',
    array: false,
    required: false
  },
  'service.origin.name': {
    type: 'keyword',
    array: false,
    required: false
  },
  'service.origin.node.name': {
    type: 'keyword',
    array: false,
    required: false
  },
  'service.origin.state': {
    type: 'keyword',
    array: false,
    required: false
  },
  'service.origin.type': {
    type: 'keyword',
    array: false,
    required: false
  },
  'service.origin.version': {
    type: 'keyword',
    array: false,
    required: false
  },
  'service.state': {
    type: 'keyword',
    array: false,
    required: false
  },
  'service.target.address': {
    type: 'keyword',
    array: false,
    required: false
  },
  'service.target.environment': {
    type: 'keyword',
    array: false,
    required: false
  },
  'service.target.ephemeral_id': {
    type: 'keyword',
    array: false,
    required: false
  },
  'service.target.id': {
    type: 'keyword',
    array: false,
    required: false
  },
  'service.target.name': {
    type: 'keyword',
    array: false,
    required: false
  },
  'service.target.node.name': {
    type: 'keyword',
    array: false,
    required: false
  },
  'service.target.state': {
    type: 'keyword',
    array: false,
    required: false
  },
  'service.target.type': {
    type: 'keyword',
    array: false,
    required: false
  },
  'service.target.version': {
    type: 'keyword',
    array: false,
    required: false
  },
  'service.type': {
    type: 'keyword',
    array: false,
    required: false
  },
  'service.version': {
    type: 'keyword',
    array: false,
    required: false
  },
  'source.address': {
    type: 'keyword',
    array: false,
    required: false
  },
  'source.as.number': {
    type: 'long',
    array: false,
    required: false
  },
  'source.as.organization.name': {
    type: 'keyword',
    array: false,
    required: false
  },
  'source.bytes': {
    type: 'long',
    array: false,
    required: false
  },
  'source.domain': {
    type: 'keyword',
    array: false,
    required: false
  },
  'source.geo.city_name': {
    type: 'keyword',
    array: false,
    required: false
  },
  'source.geo.continent_code': {
    type: 'keyword',
    array: false,
    required: false
  },
  'source.geo.continent_name': {
    type: 'keyword',
    array: false,
    required: false
  },
  'source.geo.country_iso_code': {
    type: 'keyword',
    array: false,
    required: false
  },
  'source.geo.country_name': {
    type: 'keyword',
    array: false,
    required: false
  },
  'source.geo.location': {
    type: 'geo_point',
    array: false,
    required: false
  },
  'source.geo.name': {
    type: 'keyword',
    array: false,
    required: false
  },
  'source.geo.postal_code': {
    type: 'keyword',
    array: false,
    required: false
  },
  'source.geo.region_iso_code': {
    type: 'keyword',
    array: false,
    required: false
  },
  'source.geo.region_name': {
    type: 'keyword',
    array: false,
    required: false
  },
  'source.geo.timezone': {
    type: 'keyword',
    array: false,
    required: false
  },
  'source.ip': {
    type: 'ip',
    array: false,
    required: false
  },
  'source.mac': {
    type: 'keyword',
    array: false,
    required: false
  },
  'source.nat.ip': {
    type: 'ip',
    array: false,
    required: false
  },
  'source.nat.port': {
    type: 'long',
    array: false,
    required: false
  },
  'source.packets': {
    type: 'long',
    array: false,
    required: false
  },
  'source.port': {
    type: 'long',
    array: false,
    required: false
  },
  'source.registered_domain': {
    type: 'keyword',
    array: false,
    required: false
  },
  'source.subdomain': {
    type: 'keyword',
    array: false,
    required: false
  },
  'source.top_level_domain': {
    type: 'keyword',
    array: false,
    required: false
  },
  'source.user.domain': {
    type: 'keyword',
    array: false,
    required: false
  },
  'source.user.email': {
    type: 'keyword',
    array: false,
    required: false
  },
  'source.user.full_name': {
    type: 'keyword',
    array: false,
    required: false
  },
  'source.user.group.domain': {
    type: 'keyword',
    array: false,
    required: false
  },
  'source.user.group.id': {
    type: 'keyword',
    array: false,
    required: false
  },
  'source.user.group.name': {
    type: 'keyword',
    array: false,
    required: false
  },
  'source.user.hash': {
    type: 'keyword',
    array: false,
    required: false
  },
  'source.user.id': {
    type: 'keyword',
    array: false,
    required: false
  },
  'source.user.name': {
    type: 'keyword',
    array: false,
    required: false
  },
  'source.user.roles': {
    type: 'keyword',
    array: true,
    required: false
  },
  'span.id': {
    type: 'keyword',
    array: false,
    required: false
  },
  tags: {
    type: 'keyword',
    array: true,
    required: false
  },
  'threat.enrichments': {
    type: 'nested',
    array: true,
    required: false
  },
  'threat.enrichments.indicator': {
    type: 'object',
    array: false,
    required: false
  },
  'threat.enrichments.indicator.as.number': {
    type: 'long',
    array: false,
    required: false
  },
  'threat.enrichments.indicator.as.organization.name': {
    type: 'keyword',
    array: false,
    required: false
  },
  'threat.enrichments.indicator.confidence': {
    type: 'keyword',
    array: false,
    required: false
  },
  'threat.enrichments.indicator.description': {
    type: 'keyword',
    array: false,
    required: false
  },
  'threat.enrichments.indicator.email.address': {
    type: 'keyword',
    array: false,
    required: false
  },
  'threat.enrichments.indicator.file.accessed': {
    type: 'date',
    array: false,
    required: false
  },
  'threat.enrichments.indicator.file.attributes': {
    type: 'keyword',
    array: true,
    required: false
  },
  'threat.enrichments.indicator.file.code_signature.digest_algorithm': {
    type: 'keyword',
    array: false,
    required: false
  },
  'threat.enrichments.indicator.file.code_signature.exists': {
    type: 'boolean',
    array: false,
    required: false
  },
  'threat.enrichments.indicator.file.code_signature.signing_id': {
    type: 'keyword',
    array: false,
    required: false
  },
  'threat.enrichments.indicator.file.code_signature.status': {
    type: 'keyword',
    array: false,
    required: false
  },
  'threat.enrichments.indicator.file.code_signature.subject_name': {
    type: 'keyword',
    array: false,
    required: false
  },
  'threat.enrichments.indicator.file.code_signature.team_id': {
    type: 'keyword',
    array: false,
    required: false
  },
  'threat.enrichments.indicator.file.code_signature.timestamp': {
    type: 'date',
    array: false,
    required: false
  },
  'threat.enrichments.indicator.file.code_signature.trusted': {
    type: 'boolean',
    array: false,
    required: false
  },
  'threat.enrichments.indicator.file.code_signature.valid': {
    type: 'boolean',
    array: false,
    required: false
  },
  'threat.enrichments.indicator.file.created': {
    type: 'date',
    array: false,
    required: false
  },
  'threat.enrichments.indicator.file.ctime': {
    type: 'date',
    array: false,
    required: false
  },
  'threat.enrichments.indicator.file.device': {
    type: 'keyword',
    array: false,
    required: false
  },
  'threat.enrichments.indicator.file.directory': {
    type: 'keyword',
    array: false,
    required: false
  },
  'threat.enrichments.indicator.file.drive_letter': {
    type: 'keyword',
    array: false,
    required: false
  },
  'threat.enrichments.indicator.file.elf.architecture': {
    type: 'keyword',
    array: false,
    required: false
  },
  'threat.enrichments.indicator.file.elf.byte_order': {
    type: 'keyword',
    array: false,
    required: false
  },
  'threat.enrichments.indicator.file.elf.cpu_type': {
    type: 'keyword',
    array: false,
    required: false
  },
  'threat.enrichments.indicator.file.elf.creation_date': {
    type: 'date',
    array: false,
    required: false
  },
  'threat.enrichments.indicator.file.elf.exports': {
    type: 'flattened',
    array: true,
    required: false
  },
  'threat.enrichments.indicator.file.elf.header.abi_version': {
    type: 'keyword',
    array: false,
    required: false
  },
  'threat.enrichments.indicator.file.elf.header.class': {
    type: 'keyword',
    array: false,
    required: false
  },
  'threat.enrichments.indicator.file.elf.header.data': {
    type: 'keyword',
    array: false,
    required: false
  },
  'threat.enrichments.indicator.file.elf.header.entrypoint': {
    type: 'long',
    array: false,
    required: false
  },
  'threat.enrichments.indicator.file.elf.header.object_version': {
    type: 'keyword',
    array: false,
    required: false
  },
  'threat.enrichments.indicator.file.elf.header.os_abi': {
    type: 'keyword',
    array: false,
    required: false
  },
  'threat.enrichments.indicator.file.elf.header.type': {
    type: 'keyword',
    array: false,
    required: false
  },
  'threat.enrichments.indicator.file.elf.header.version': {
    type: 'keyword',
    array: false,
    required: false
  },
  'threat.enrichments.indicator.file.elf.imports': {
    type: 'flattened',
    array: true,
    required: false
  },
  'threat.enrichments.indicator.file.elf.sections': {
    type: 'nested',
    array: true,
    required: false
  },
  'threat.enrichments.indicator.file.elf.sections.chi2': {
    type: 'long',
    array: false,
    required: false
  },
  'threat.enrichments.indicator.file.elf.sections.entropy': {
    type: 'long',
    array: false,
    required: false
  },
  'threat.enrichments.indicator.file.elf.sections.flags': {
    type: 'keyword',
    array: false,
    required: false
  },
  'threat.enrichments.indicator.file.elf.sections.name': {
    type: 'keyword',
    array: false,
    required: false
  },
  'threat.enrichments.indicator.file.elf.sections.physical_offset': {
    type: 'keyword',
    array: false,
    required: false
  },
  'threat.enrichments.indicator.file.elf.sections.physical_size': {
    type: 'long',
    array: false,
    required: false
  },
  'threat.enrichments.indicator.file.elf.sections.type': {
    type: 'keyword',
    array: false,
    required: false
  },
  'threat.enrichments.indicator.file.elf.sections.virtual_address': {
    type: 'long',
    array: false,
    required: false
  },
  'threat.enrichments.indicator.file.elf.sections.virtual_size': {
    type: 'long',
    array: false,
    required: false
  },
  'threat.enrichments.indicator.file.elf.segments': {
    type: 'nested',
    array: true,
    required: false
  },
  'threat.enrichments.indicator.file.elf.segments.sections': {
    type: 'keyword',
    array: false,
    required: false
  },
  'threat.enrichments.indicator.file.elf.segments.type': {
    type: 'keyword',
    array: false,
    required: false
  },
  'threat.enrichments.indicator.file.elf.shared_libraries': {
    type: 'keyword',
    array: true,
    required: false
  },
  'threat.enrichments.indicator.file.elf.telfhash': {
    type: 'keyword',
    array: false,
    required: false
  },
  'threat.enrichments.indicator.file.extension': {
    type: 'keyword',
    array: false,
    required: false
  },
  'threat.enrichments.indicator.file.fork_name': {
    type: 'keyword',
    array: false,
    required: false
  },
  'threat.enrichments.indicator.file.gid': {
    type: 'keyword',
    array: false,
    required: false
  },
  'threat.enrichments.indicator.file.group': {
    type: 'keyword',
    array: false,
    required: false
  },
  'threat.enrichments.indicator.file.hash.md5': {
    type: 'keyword',
    array: false,
    required: false
  },
  'threat.enrichments.indicator.file.hash.sha1': {
    type: 'keyword',
    array: false,
    required: false
  },
  'threat.enrichments.indicator.file.hash.sha256': {
    type: 'keyword',
    array: false,
    required: false
  },
  'threat.enrichments.indicator.file.hash.sha512': {
    type: 'keyword',
    array: false,
    required: false
  },
  'threat.enrichments.indicator.file.hash.ssdeep': {
    type: 'keyword',
    array: false,
    required: false
  },
  'threat.enrichments.indicator.file.inode': {
    type: 'keyword',
    array: false,
    required: false
  },
  'threat.enrichments.indicator.file.mime_type': {
    type: 'keyword',
    array: false,
    required: false
  },
  'threat.enrichments.indicator.file.mode': {
    type: 'keyword',
    array: false,
    required: false
  },
  'threat.enrichments.indicator.file.mtime': {
    type: 'date',
    array: false,
    required: false
  },
  'threat.enrichments.indicator.file.name': {
    type: 'keyword',
    array: false,
    required: false
  },
  'threat.enrichments.indicator.file.owner': {
    type: 'keyword',
    array: false,
    required: false
  },
  'threat.enrichments.indicator.file.path': {
    type: 'keyword',
    array: false,
    required: false
  },
  'threat.enrichments.indicator.file.pe.architecture': {
    type: 'keyword',
    array: false,
    required: false
  },
  'threat.enrichments.indicator.file.pe.company': {
    type: 'keyword',
    array: false,
    required: false
  },
  'threat.enrichments.indicator.file.pe.description': {
    type: 'keyword',
    array: false,
    required: false
  },
  'threat.enrichments.indicator.file.pe.file_version': {
    type: 'keyword',
    array: false,
    required: false
  },
  'threat.enrichments.indicator.file.pe.imphash': {
    type: 'keyword',
    array: false,
    required: false
  },
  'threat.enrichments.indicator.file.pe.original_file_name': {
    type: 'keyword',
    array: false,
    required: false
  },
  'threat.enrichments.indicator.file.pe.product': {
    type: 'keyword',
    array: false,
    required: false
  },
  'threat.enrichments.indicator.file.size': {
    type: 'long',
    array: false,
    required: false
  },
  'threat.enrichments.indicator.file.target_path': {
    type: 'keyword',
    array: false,
    required: false
  },
  'threat.enrichments.indicator.file.type': {
    type: 'keyword',
    array: false,
    required: false
  },
  'threat.enrichments.indicator.file.uid': {
    type: 'keyword',
    array: false,
    required: false
  },
  'threat.enrichments.indicator.file.x509.alternative_names': {
    type: 'keyword',
    array: true,
    required: false
  },
  'threat.enrichments.indicator.file.x509.issuer.common_name': {
    type: 'keyword',
    array: true,
    required: false
  },
  'threat.enrichments.indicator.file.x509.issuer.country': {
    type: 'keyword',
    array: true,
    required: false
  },
  'threat.enrichments.indicator.file.x509.issuer.distinguished_name': {
    type: 'keyword',
    array: false,
    required: false
  },
  'threat.enrichments.indicator.file.x509.issuer.locality': {
    type: 'keyword',
    array: true,
    required: false
  },
  'threat.enrichments.indicator.file.x509.issuer.organization': {
    type: 'keyword',
    array: true,
    required: false
  },
  'threat.enrichments.indicator.file.x509.issuer.organizational_unit': {
    type: 'keyword',
    array: true,
    required: false
  },
  'threat.enrichments.indicator.file.x509.issuer.state_or_province': {
    type: 'keyword',
    array: true,
    required: false
  },
  'threat.enrichments.indicator.file.x509.not_after': {
    type: 'date',
    array: false,
    required: false
  },
  'threat.enrichments.indicator.file.x509.not_before': {
    type: 'date',
    array: false,
    required: false
  },
  'threat.enrichments.indicator.file.x509.public_key_algorithm': {
    type: 'keyword',
    array: false,
    required: false
  },
  'threat.enrichments.indicator.file.x509.public_key_curve': {
    type: 'keyword',
    array: false,
    required: false
  },
  'threat.enrichments.indicator.file.x509.public_key_exponent': {
    type: 'long',
    array: false,
    required: false
  },
  'threat.enrichments.indicator.file.x509.public_key_size': {
    type: 'long',
    array: false,
    required: false
  },
  'threat.enrichments.indicator.file.x509.serial_number': {
    type: 'keyword',
    array: false,
    required: false
  },
  'threat.enrichments.indicator.file.x509.signature_algorithm': {
    type: 'keyword',
    array: false,
    required: false
  },
  'threat.enrichments.indicator.file.x509.subject.common_name': {
    type: 'keyword',
    array: true,
    required: false
  },
  'threat.enrichments.indicator.file.x509.subject.country': {
    type: 'keyword',
    array: true,
    required: false
  },
  'threat.enrichments.indicator.file.x509.subject.distinguished_name': {
    type: 'keyword',
    array: false,
    required: false
  },
  'threat.enrichments.indicator.file.x509.subject.locality': {
    type: 'keyword',
    array: true,
    required: false
  },
  'threat.enrichments.indicator.file.x509.subject.organization': {
    type: 'keyword',
    array: true,
    required: false
  },
  'threat.enrichments.indicator.file.x509.subject.organizational_unit': {
    type: 'keyword',
    array: true,
    required: false
  },
  'threat.enrichments.indicator.file.x509.subject.state_or_province': {
    type: 'keyword',
    array: true,
    required: false
  },
  'threat.enrichments.indicator.file.x509.version_number': {
    type: 'keyword',
    array: false,
    required: false
  },
  'threat.enrichments.indicator.first_seen': {
    type: 'date',
    array: false,
    required: false
  },
  'threat.enrichments.indicator.geo.city_name': {
    type: 'keyword',
    array: false,
    required: false
  },
  'threat.enrichments.indicator.geo.continent_code': {
    type: 'keyword',
    array: false,
    required: false
  },
  'threat.enrichments.indicator.geo.continent_name': {
    type: 'keyword',
    array: false,
    required: false
  },
  'threat.enrichments.indicator.geo.country_iso_code': {
    type: 'keyword',
    array: false,
    required: false
  },
  'threat.enrichments.indicator.geo.country_name': {
    type: 'keyword',
    array: false,
    required: false
  },
  'threat.enrichments.indicator.geo.location': {
    type: 'geo_point',
    array: false,
    required: false
  },
  'threat.enrichments.indicator.geo.name': {
    type: 'keyword',
    array: false,
    required: false
  },
  'threat.enrichments.indicator.geo.postal_code': {
    type: 'keyword',
    array: false,
    required: false
  },
  'threat.enrichments.indicator.geo.region_iso_code': {
    type: 'keyword',
    array: false,
    required: false
  },
  'threat.enrichments.indicator.geo.region_name': {
    type: 'keyword',
    array: false,
    required: false
  },
  'threat.enrichments.indicator.geo.timezone': {
    type: 'keyword',
    array: false,
    required: false
  },
  'threat.enrichments.indicator.ip': {
    type: 'ip',
    array: false,
    required: false
  },
  'threat.enrichments.indicator.last_seen': {
    type: 'date',
    array: false,
    required: false
  },
  'threat.enrichments.indicator.marking.tlp': {
    type: 'keyword',
    array: false,
    required: false
  },
  'threat.enrichments.indicator.modified_at': {
    type: 'date',
    array: false,
    required: false
  },
  'threat.enrichments.indicator.port': {
    type: 'long',
    array: false,
    required: false
  },
  'threat.enrichments.indicator.provider': {
    type: 'keyword',
    array: false,
    required: false
  },
  'threat.enrichments.indicator.reference': {
    type: 'keyword',
    array: false,
    required: false
  },
  'threat.enrichments.indicator.registry.data.bytes': {
    type: 'keyword',
    array: false,
    required: false
  },
  'threat.enrichments.indicator.registry.data.strings': {
    type: 'wildcard',
    array: true,
    required: false
  },
  'threat.enrichments.indicator.registry.data.type': {
    type: 'keyword',
    array: false,
    required: false
  },
  'threat.enrichments.indicator.registry.hive': {
    type: 'keyword',
    array: false,
    required: false
  },
  'threat.enrichments.indicator.registry.key': {
    type: 'keyword',
    array: false,
    required: false
  },
  'threat.enrichments.indicator.registry.path': {
    type: 'keyword',
    array: false,
    required: false
  },
  'threat.enrichments.indicator.registry.value': {
    type: 'keyword',
    array: false,
    required: false
  },
  'threat.enrichments.indicator.scanner_stats': {
    type: 'long',
    array: false,
    required: false
  },
  'threat.enrichments.indicator.sightings': {
    type: 'long',
    array: false,
    required: false
  },
  'threat.enrichments.indicator.type': {
    type: 'keyword',
    array: false,
    required: false
  },
  'threat.enrichments.indicator.url.domain': {
    type: 'keyword',
    array: false,
    required: false
  },
  'threat.enrichments.indicator.url.extension': {
    type: 'keyword',
    array: false,
    required: false
  },
  'threat.enrichments.indicator.url.fragment': {
    type: 'keyword',
    array: false,
    required: false
  },
  'threat.enrichments.indicator.url.full': {
    type: 'wildcard',
    array: false,
    required: false
  },
  'threat.enrichments.indicator.url.original': {
    type: 'wildcard',
    array: false,
    required: false
  },
  'threat.enrichments.indicator.url.password': {
    type: 'keyword',
    array: false,
    required: false
  },
  'threat.enrichments.indicator.url.path': {
    type: 'wildcard',
    array: false,
    required: false
  },
  'threat.enrichments.indicator.url.port': {
    type: 'long',
    array: false,
    required: false
  },
  'threat.enrichments.indicator.url.query': {
    type: 'keyword',
    array: false,
    required: false
  },
  'threat.enrichments.indicator.url.registered_domain': {
    type: 'keyword',
    array: false,
    required: false
  },
  'threat.enrichments.indicator.url.scheme': {
    type: 'keyword',
    array: false,
    required: false
  },
  'threat.enrichments.indicator.url.subdomain': {
    type: 'keyword',
    array: false,
    required: false
  },
  'threat.enrichments.indicator.url.top_level_domain': {
    type: 'keyword',
    array: false,
    required: false
  },
  'threat.enrichments.indicator.url.username': {
    type: 'keyword',
    array: false,
    required: false
  },
  'threat.enrichments.indicator.x509.alternative_names': {
    type: 'keyword',
    array: true,
    required: false
  },
  'threat.enrichments.indicator.x509.issuer.common_name': {
    type: 'keyword',
    array: true,
    required: false
  },
  'threat.enrichments.indicator.x509.issuer.country': {
    type: 'keyword',
    array: true,
    required: false
  },
  'threat.enrichments.indicator.x509.issuer.distinguished_name': {
    type: 'keyword',
    array: false,
    required: false
  },
  'threat.enrichments.indicator.x509.issuer.locality': {
    type: 'keyword',
    array: true,
    required: false
  },
  'threat.enrichments.indicator.x509.issuer.organization': {
    type: 'keyword',
    array: true,
    required: false
  },
  'threat.enrichments.indicator.x509.issuer.organizational_unit': {
    type: 'keyword',
    array: true,
    required: false
  },
  'threat.enrichments.indicator.x509.issuer.state_or_province': {
    type: 'keyword',
    array: true,
    required: false
  },
  'threat.enrichments.indicator.x509.not_after': {
    type: 'date',
    array: false,
    required: false
  },
  'threat.enrichments.indicator.x509.not_before': {
    type: 'date',
    array: false,
    required: false
  },
  'threat.enrichments.indicator.x509.public_key_algorithm': {
    type: 'keyword',
    array: false,
    required: false
  },
  'threat.enrichments.indicator.x509.public_key_curve': {
    type: 'keyword',
    array: false,
    required: false
  },
  'threat.enrichments.indicator.x509.public_key_exponent': {
    type: 'long',
    array: false,
    required: false
  },
  'threat.enrichments.indicator.x509.public_key_size': {
    type: 'long',
    array: false,
    required: false
  },
  'threat.enrichments.indicator.x509.serial_number': {
    type: 'keyword',
    array: false,
    required: false
  },
  'threat.enrichments.indicator.x509.signature_algorithm': {
    type: 'keyword',
    array: false,
    required: false
  },
  'threat.enrichments.indicator.x509.subject.common_name': {
    type: 'keyword',
    array: true,
    required: false
  },
  'threat.enrichments.indicator.x509.subject.country': {
    type: 'keyword',
    array: true,
    required: false
  },
  'threat.enrichments.indicator.x509.subject.distinguished_name': {
    type: 'keyword',
    array: false,
    required: false
  },
  'threat.enrichments.indicator.x509.subject.locality': {
    type: 'keyword',
    array: true,
    required: false
  },
  'threat.enrichments.indicator.x509.subject.organization': {
    type: 'keyword',
    array: true,
    required: false
  },
  'threat.enrichments.indicator.x509.subject.organizational_unit': {
    type: 'keyword',
    array: true,
    required: false
  },
  'threat.enrichments.indicator.x509.subject.state_or_province': {
    type: 'keyword',
    array: true,
    required: false
  },
  'threat.enrichments.indicator.x509.version_number': {
    type: 'keyword',
    array: false,
    required: false
  },
  'threat.enrichments.matched.atomic': {
    type: 'keyword',
    array: false,
    required: false
  },
  'threat.enrichments.matched.field': {
    type: 'keyword',
    array: false,
    required: false
  },
  'threat.enrichments.matched.id': {
    type: 'keyword',
    array: false,
    required: false
  },
  'threat.enrichments.matched.index': {
    type: 'keyword',
    array: false,
    required: false
  },
  'threat.enrichments.matched.type': {
    type: 'keyword',
    array: false,
    required: false
  },
  'threat.framework': {
    type: 'keyword',
    array: false,
    required: false
  },
  'threat.group.alias': {
    type: 'keyword',
    array: true,
    required: false
  },
  'threat.group.id': {
    type: 'keyword',
    array: false,
    required: false
  },
  'threat.group.name': {
    type: 'keyword',
    array: false,
    required: false
  },
  'threat.group.reference': {
    type: 'keyword',
    array: false,
    required: false
  },
  'threat.indicator.as.number': {
    type: 'long',
    array: false,
    required: false
  },
  'threat.indicator.as.organization.name': {
    type: 'keyword',
    array: false,
    required: false
  },
  'threat.indicator.confidence': {
    type: 'keyword',
    array: false,
    required: false
  },
  'threat.indicator.description': {
    type: 'keyword',
    array: false,
    required: false
  },
  'threat.indicator.email.address': {
    type: 'keyword',
    array: false,
    required: false
  },
  'threat.indicator.file.accessed': {
    type: 'date',
    array: false,
    required: false
  },
  'threat.indicator.file.attributes': {
    type: 'keyword',
    array: true,
    required: false
  },
  'threat.indicator.file.code_signature.digest_algorithm': {
    type: 'keyword',
    array: false,
    required: false
  },
  'threat.indicator.file.code_signature.exists': {
    type: 'boolean',
    array: false,
    required: false
  },
  'threat.indicator.file.code_signature.signing_id': {
    type: 'keyword',
    array: false,
    required: false
  },
  'threat.indicator.file.code_signature.status': {
    type: 'keyword',
    array: false,
    required: false
  },
  'threat.indicator.file.code_signature.subject_name': {
    type: 'keyword',
    array: false,
    required: false
  },
  'threat.indicator.file.code_signature.team_id': {
    type: 'keyword',
    array: false,
    required: false
  },
  'threat.indicator.file.code_signature.timestamp': {
    type: 'date',
    array: false,
    required: false
  },
  'threat.indicator.file.code_signature.trusted': {
    type: 'boolean',
    array: false,
    required: false
  },
  'threat.indicator.file.code_signature.valid': {
    type: 'boolean',
    array: false,
    required: false
  },
  'threat.indicator.file.created': {
    type: 'date',
    array: false,
    required: false
  },
  'threat.indicator.file.ctime': {
    type: 'date',
    array: false,
    required: false
  },
  'threat.indicator.file.device': {
    type: 'keyword',
    array: false,
    required: false
  },
  'threat.indicator.file.directory': {
    type: 'keyword',
    array: false,
    required: false
  },
  'threat.indicator.file.drive_letter': {
    type: 'keyword',
    array: false,
    required: false
  },
  'threat.indicator.file.elf.architecture': {
    type: 'keyword',
    array: false,
    required: false
  },
  'threat.indicator.file.elf.byte_order': {
    type: 'keyword',
    array: false,
    required: false
  },
  'threat.indicator.file.elf.cpu_type': {
    type: 'keyword',
    array: false,
    required: false
  },
  'threat.indicator.file.elf.creation_date': {
    type: 'date',
    array: false,
    required: false
  },
  'threat.indicator.file.elf.exports': {
    type: 'flattened',
    array: true,
    required: false
  },
  'threat.indicator.file.elf.header.abi_version': {
    type: 'keyword',
    array: false,
    required: false
  },
  'threat.indicator.file.elf.header.class': {
    type: 'keyword',
    array: false,
    required: false
  },
  'threat.indicator.file.elf.header.data': {
    type: 'keyword',
    array: false,
    required: false
  },
  'threat.indicator.file.elf.header.entrypoint': {
    type: 'long',
    array: false,
    required: false
  },
  'threat.indicator.file.elf.header.object_version': {
    type: 'keyword',
    array: false,
    required: false
  },
  'threat.indicator.file.elf.header.os_abi': {
    type: 'keyword',
    array: false,
    required: false
  },
  'threat.indicator.file.elf.header.type': {
    type: 'keyword',
    array: false,
    required: false
  },
  'threat.indicator.file.elf.header.version': {
    type: 'keyword',
    array: false,
    required: false
  },
  'threat.indicator.file.elf.imports': {
    type: 'flattened',
    array: true,
    required: false
  },
  'threat.indicator.file.elf.sections': {
    type: 'nested',
    array: true,
    required: false
  },
  'threat.indicator.file.elf.sections.chi2': {
    type: 'long',
    array: false,
    required: false
  },
  'threat.indicator.file.elf.sections.entropy': {
    type: 'long',
    array: false,
    required: false
  },
  'threat.indicator.file.elf.sections.flags': {
    type: 'keyword',
    array: false,
    required: false
  },
  'threat.indicator.file.elf.sections.name': {
    type: 'keyword',
    array: false,
    required: false
  },
  'threat.indicator.file.elf.sections.physical_offset': {
    type: 'keyword',
    array: false,
    required: false
  },
  'threat.indicator.file.elf.sections.physical_size': {
    type: 'long',
    array: false,
    required: false
  },
  'threat.indicator.file.elf.sections.type': {
    type: 'keyword',
    array: false,
    required: false
  },
  'threat.indicator.file.elf.sections.virtual_address': {
    type: 'long',
    array: false,
    required: false
  },
  'threat.indicator.file.elf.sections.virtual_size': {
    type: 'long',
    array: false,
    required: false
  },
  'threat.indicator.file.elf.segments': {
    type: 'nested',
    array: true,
    required: false
  },
  'threat.indicator.file.elf.segments.sections': {
    type: 'keyword',
    array: false,
    required: false
  },
  'threat.indicator.file.elf.segments.type': {
    type: 'keyword',
    array: false,
    required: false
  },
  'threat.indicator.file.elf.shared_libraries': {
    type: 'keyword',
    array: true,
    required: false
  },
  'threat.indicator.file.elf.telfhash': {
    type: 'keyword',
    array: false,
    required: false
  },
  'threat.indicator.file.extension': {
    type: 'keyword',
    array: false,
    required: false
  },
  'threat.indicator.file.fork_name': {
    type: 'keyword',
    array: false,
    required: false
  },
  'threat.indicator.file.gid': {
    type: 'keyword',
    array: false,
    required: false
  },
  'threat.indicator.file.group': {
    type: 'keyword',
    array: false,
    required: false
  },
  'threat.indicator.file.hash.md5': {
    type: 'keyword',
    array: false,
    required: false
  },
  'threat.indicator.file.hash.sha1': {
    type: 'keyword',
    array: false,
    required: false
  },
  'threat.indicator.file.hash.sha256': {
    type: 'keyword',
    array: false,
    required: false
  },
  'threat.indicator.file.hash.sha512': {
    type: 'keyword',
    array: false,
    required: false
  },
  'threat.indicator.file.hash.ssdeep': {
    type: 'keyword',
    array: false,
    required: false
  },
  'threat.indicator.file.inode': {
    type: 'keyword',
    array: false,
    required: false
  },
  'threat.indicator.file.mime_type': {
    type: 'keyword',
    array: false,
    required: false
  },
  'threat.indicator.file.mode': {
    type: 'keyword',
    array: false,
    required: false
  },
  'threat.indicator.file.mtime': {
    type: 'date',
    array: false,
    required: false
  },
  'threat.indicator.file.name': {
    type: 'keyword',
    array: false,
    required: false
  },
  'threat.indicator.file.owner': {
    type: 'keyword',
    array: false,
    required: false
  },
  'threat.indicator.file.path': {
    type: 'keyword',
    array: false,
    required: false
  },
  'threat.indicator.file.pe.architecture': {
    type: 'keyword',
    array: false,
    required: false
  },
  'threat.indicator.file.pe.company': {
    type: 'keyword',
    array: false,
    required: false
  },
  'threat.indicator.file.pe.description': {
    type: 'keyword',
    array: false,
    required: false
  },
  'threat.indicator.file.pe.file_version': {
    type: 'keyword',
    array: false,
    required: false
  },
  'threat.indicator.file.pe.imphash': {
    type: 'keyword',
    array: false,
    required: false
  },
  'threat.indicator.file.pe.original_file_name': {
    type: 'keyword',
    array: false,
    required: false
  },
  'threat.indicator.file.pe.product': {
    type: 'keyword',
    array: false,
    required: false
  },
  'threat.indicator.file.size': {
    type: 'long',
    array: false,
    required: false
  },
  'threat.indicator.file.target_path': {
    type: 'keyword',
    array: false,
    required: false
  },
  'threat.indicator.file.type': {
    type: 'keyword',
    array: false,
    required: false
  },
  'threat.indicator.file.uid': {
    type: 'keyword',
    array: false,
    required: false
  },
  'threat.indicator.file.x509.alternative_names': {
    type: 'keyword',
    array: true,
    required: false
  },
  'threat.indicator.file.x509.issuer.common_name': {
    type: 'keyword',
    array: true,
    required: false
  },
  'threat.indicator.file.x509.issuer.country': {
    type: 'keyword',
    array: true,
    required: false
  },
  'threat.indicator.file.x509.issuer.distinguished_name': {
    type: 'keyword',
    array: false,
    required: false
  },
  'threat.indicator.file.x509.issuer.locality': {
    type: 'keyword',
    array: true,
    required: false
  },
  'threat.indicator.file.x509.issuer.organization': {
    type: 'keyword',
    array: true,
    required: false
  },
  'threat.indicator.file.x509.issuer.organizational_unit': {
    type: 'keyword',
    array: true,
    required: false
  },
  'threat.indicator.file.x509.issuer.state_or_province': {
    type: 'keyword',
    array: true,
    required: false
  },
  'threat.indicator.file.x509.not_after': {
    type: 'date',
    array: false,
    required: false
  },
  'threat.indicator.file.x509.not_before': {
    type: 'date',
    array: false,
    required: false
  },
  'threat.indicator.file.x509.public_key_algorithm': {
    type: 'keyword',
    array: false,
    required: false
  },
  'threat.indicator.file.x509.public_key_curve': {
    type: 'keyword',
    array: false,
    required: false
  },
  'threat.indicator.file.x509.public_key_exponent': {
    type: 'long',
    array: false,
    required: false
  },
  'threat.indicator.file.x509.public_key_size': {
    type: 'long',
    array: false,
    required: false
  },
  'threat.indicator.file.x509.serial_number': {
    type: 'keyword',
    array: false,
    required: false
  },
  'threat.indicator.file.x509.signature_algorithm': {
    type: 'keyword',
    array: false,
    required: false
  },
  'threat.indicator.file.x509.subject.common_name': {
    type: 'keyword',
    array: true,
    required: false
  },
  'threat.indicator.file.x509.subject.country': {
    type: 'keyword',
    array: true,
    required: false
  },
  'threat.indicator.file.x509.subject.distinguished_name': {
    type: 'keyword',
    array: false,
    required: false
  },
  'threat.indicator.file.x509.subject.locality': {
    type: 'keyword',
    array: true,
    required: false
  },
  'threat.indicator.file.x509.subject.organization': {
    type: 'keyword',
    array: true,
    required: false
  },
  'threat.indicator.file.x509.subject.organizational_unit': {
    type: 'keyword',
    array: true,
    required: false
  },
  'threat.indicator.file.x509.subject.state_or_province': {
    type: 'keyword',
    array: true,
    required: false
  },
  'threat.indicator.file.x509.version_number': {
    type: 'keyword',
    array: false,
    required: false
  },
  'threat.indicator.first_seen': {
    type: 'date',
    array: false,
    required: false
  },
  'threat.indicator.geo.city_name': {
    type: 'keyword',
    array: false,
    required: false
  },
  'threat.indicator.geo.continent_code': {
    type: 'keyword',
    array: false,
    required: false
  },
  'threat.indicator.geo.continent_name': {
    type: 'keyword',
    array: false,
    required: false
  },
  'threat.indicator.geo.country_iso_code': {
    type: 'keyword',
    array: false,
    required: false
  },
  'threat.indicator.geo.country_name': {
    type: 'keyword',
    array: false,
    required: false
  },
  'threat.indicator.geo.location': {
    type: 'geo_point',
    array: false,
    required: false
  },
  'threat.indicator.geo.name': {
    type: 'keyword',
    array: false,
    required: false
  },
  'threat.indicator.geo.postal_code': {
    type: 'keyword',
    array: false,
    required: false
  },
  'threat.indicator.geo.region_iso_code': {
    type: 'keyword',
    array: false,
    required: false
  },
  'threat.indicator.geo.region_name': {
    type: 'keyword',
    array: false,
    required: false
  },
  'threat.indicator.geo.timezone': {
    type: 'keyword',
    array: false,
    required: false
  },
  'threat.indicator.ip': {
    type: 'ip',
    array: false,
    required: false
  },
  'threat.indicator.last_seen': {
    type: 'date',
    array: false,
    required: false
  },
  'threat.indicator.marking.tlp': {
    type: 'keyword',
    array: false,
    required: false
  },
  'threat.indicator.modified_at': {
    type: 'date',
    array: false,
    required: false
  },
  'threat.indicator.port': {
    type: 'long',
    array: false,
    required: false
  },
  'threat.indicator.provider': {
    type: 'keyword',
    array: false,
    required: false
  },
  'threat.indicator.reference': {
    type: 'keyword',
    array: false,
    required: false
  },
  'threat.indicator.registry.data.bytes': {
    type: 'keyword',
    array: false,
    required: false
  },
  'threat.indicator.registry.data.strings': {
    type: 'wildcard',
    array: true,
    required: false
  },
  'threat.indicator.registry.data.type': {
    type: 'keyword',
    array: false,
    required: false
  },
  'threat.indicator.registry.hive': {
    type: 'keyword',
    array: false,
    required: false
  },
  'threat.indicator.registry.key': {
    type: 'keyword',
    array: false,
    required: false
  },
  'threat.indicator.registry.path': {
    type: 'keyword',
    array: false,
    required: false
  },
  'threat.indicator.registry.value': {
    type: 'keyword',
    array: false,
    required: false
  },
  'threat.indicator.scanner_stats': {
    type: 'long',
    array: false,
    required: false
  },
  'threat.indicator.sightings': {
    type: 'long',
    array: false,
    required: false
  },
  'threat.indicator.type': {
    type: 'keyword',
    array: false,
    required: false
  },
  'threat.indicator.url.domain': {
    type: 'keyword',
    array: false,
    required: false
  },
  'threat.indicator.url.extension': {
    type: 'keyword',
    array: false,
    required: false
  },
  'threat.indicator.url.fragment': {
    type: 'keyword',
    array: false,
    required: false
  },
  'threat.indicator.url.full': {
    type: 'wildcard',
    array: false,
    required: false
  },
  'threat.indicator.url.original': {
    type: 'wildcard',
    array: false,
    required: false
  },
  'threat.indicator.url.password': {
    type: 'keyword',
    array: false,
    required: false
  },
  'threat.indicator.url.path': {
    type: 'wildcard',
    array: false,
    required: false
  },
  'threat.indicator.url.port': {
    type: 'long',
    array: false,
    required: false
  },
  'threat.indicator.url.query': {
    type: 'keyword',
    array: false,
    required: false
  },
  'threat.indicator.url.registered_domain': {
    type: 'keyword',
    array: false,
    required: false
  },
  'threat.indicator.url.scheme': {
    type: 'keyword',
    array: false,
    required: false
  },
  'threat.indicator.url.subdomain': {
    type: 'keyword',
    array: false,
    required: false
  },
  'threat.indicator.url.top_level_domain': {
    type: 'keyword',
    array: false,
    required: false
  },
  'threat.indicator.url.username': {
    type: 'keyword',
    array: false,
    required: false
  },
  'threat.indicator.x509.alternative_names': {
    type: 'keyword',
    array: true,
    required: false
  },
  'threat.indicator.x509.issuer.common_name': {
    type: 'keyword',
    array: true,
    required: false
  },
  'threat.indicator.x509.issuer.country': {
    type: 'keyword',
    array: true,
    required: false
  },
  'threat.indicator.x509.issuer.distinguished_name': {
    type: 'keyword',
    array: false,
    required: false
  },
  'threat.indicator.x509.issuer.locality': {
    type: 'keyword',
    array: true,
    required: false
  },
  'threat.indicator.x509.issuer.organization': {
    type: 'keyword',
    array: true,
    required: false
  },
  'threat.indicator.x509.issuer.organizational_unit': {
    type: 'keyword',
    array: true,
    required: false
  },
  'threat.indicator.x509.issuer.state_or_province': {
    type: 'keyword',
    array: true,
    required: false
  },
  'threat.indicator.x509.not_after': {
    type: 'date',
    array: false,
    required: false
  },
  'threat.indicator.x509.not_before': {
    type: 'date',
    array: false,
    required: false
  },
  'threat.indicator.x509.public_key_algorithm': {
    type: 'keyword',
    array: false,
    required: false
  },
  'threat.indicator.x509.public_key_curve': {
    type: 'keyword',
    array: false,
    required: false
  },
  'threat.indicator.x509.public_key_exponent': {
    type: 'long',
    array: false,
    required: false
  },
  'threat.indicator.x509.public_key_size': {
    type: 'long',
    array: false,
    required: false
  },
  'threat.indicator.x509.serial_number': {
    type: 'keyword',
    array: false,
    required: false
  },
  'threat.indicator.x509.signature_algorithm': {
    type: 'keyword',
    array: false,
    required: false
  },
  'threat.indicator.x509.subject.common_name': {
    type: 'keyword',
    array: true,
    required: false
  },
  'threat.indicator.x509.subject.country': {
    type: 'keyword',
    array: true,
    required: false
  },
  'threat.indicator.x509.subject.distinguished_name': {
    type: 'keyword',
    array: false,
    required: false
  },
  'threat.indicator.x509.subject.locality': {
    type: 'keyword',
    array: true,
    required: false
  },
  'threat.indicator.x509.subject.organization': {
    type: 'keyword',
    array: true,
    required: false
  },
  'threat.indicator.x509.subject.organizational_unit': {
    type: 'keyword',
    array: true,
    required: false
  },
  'threat.indicator.x509.subject.state_or_province': {
    type: 'keyword',
    array: true,
    required: false
  },
  'threat.indicator.x509.version_number': {
    type: 'keyword',
    array: false,
    required: false
  },
  'threat.software.alias': {
    type: 'keyword',
    array: true,
    required: false
  },
  'threat.software.id': {
    type: 'keyword',
    array: false,
    required: false
  },
  'threat.software.name': {
    type: 'keyword',
    array: false,
    required: false
  },
  'threat.software.platforms': {
    type: 'keyword',
    array: true,
    required: false
  },
  'threat.software.reference': {
    type: 'keyword',
    array: false,
    required: false
  },
  'threat.software.type': {
    type: 'keyword',
    array: false,
    required: false
  },
  'threat.tactic.id': {
    type: 'keyword',
    array: true,
    required: false
  },
  'threat.tactic.name': {
    type: 'keyword',
    array: true,
    required: false
  },
  'threat.tactic.reference': {
    type: 'keyword',
    array: true,
    required: false
  },
  'threat.technique.id': {
    type: 'keyword',
    array: true,
    required: false
  },
  'threat.technique.name': {
    type: 'keyword',
    array: true,
    required: false
  },
  'threat.technique.reference': {
    type: 'keyword',
    array: true,
    required: false
  },
  'threat.technique.subtechnique.id': {
    type: 'keyword',
    array: true,
    required: false
  },
  'threat.technique.subtechnique.name': {
    type: 'keyword',
    array: true,
    required: false
  },
  'threat.technique.subtechnique.reference': {
    type: 'keyword',
    array: true,
    required: false
  },
  'tls.cipher': {
    type: 'keyword',
    array: false,
    required: false
  },
  'tls.client.certificate': {
    type: 'keyword',
    array: false,
    required: false
  },
  'tls.client.certificate_chain': {
    type: 'keyword',
    array: true,
    required: false
  },
  'tls.client.hash.md5': {
    type: 'keyword',
    array: false,
    required: false
  },
  'tls.client.hash.sha1': {
    type: 'keyword',
    array: false,
    required: false
  },
  'tls.client.hash.sha256': {
    type: 'keyword',
    array: false,
    required: false
  },
  'tls.client.issuer': {
    type: 'keyword',
    array: false,
    required: false
  },
  'tls.client.ja3': {
    type: 'keyword',
    array: false,
    required: false
  },
  'tls.client.not_after': {
    type: 'date',
    array: false,
    required: false
  },
  'tls.client.not_before': {
    type: 'date',
    array: false,
    required: false
  },
  'tls.client.server_name': {
    type: 'keyword',
    array: false,
    required: false
  },
  'tls.client.subject': {
    type: 'keyword',
    array: false,
    required: false
  },
  'tls.client.supported_ciphers': {
    type: 'keyword',
    array: true,
    required: false
  },
  'tls.client.x509.alternative_names': {
    type: 'keyword',
    array: true,
    required: false
  },
  'tls.client.x509.issuer.common_name': {
    type: 'keyword',
    array: true,
    required: false
  },
  'tls.client.x509.issuer.country': {
    type: 'keyword',
    array: true,
    required: false
  },
  'tls.client.x509.issuer.distinguished_name': {
    type: 'keyword',
    array: false,
    required: false
  },
  'tls.client.x509.issuer.locality': {
    type: 'keyword',
    array: true,
    required: false
  },
  'tls.client.x509.issuer.organization': {
    type: 'keyword',
    array: true,
    required: false
  },
  'tls.client.x509.issuer.organizational_unit': {
    type: 'keyword',
    array: true,
    required: false
  },
  'tls.client.x509.issuer.state_or_province': {
    type: 'keyword',
    array: true,
    required: false
  },
  'tls.client.x509.not_after': {
    type: 'date',
    array: false,
    required: false
  },
  'tls.client.x509.not_before': {
    type: 'date',
    array: false,
    required: false
  },
  'tls.client.x509.public_key_algorithm': {
    type: 'keyword',
    array: false,
    required: false
  },
  'tls.client.x509.public_key_curve': {
    type: 'keyword',
    array: false,
    required: false
  },
  'tls.client.x509.public_key_exponent': {
    type: 'long',
    array: false,
    required: false
  },
  'tls.client.x509.public_key_size': {
    type: 'long',
    array: false,
    required: false
  },
  'tls.client.x509.serial_number': {
    type: 'keyword',
    array: false,
    required: false
  },
  'tls.client.x509.signature_algorithm': {
    type: 'keyword',
    array: false,
    required: false
  },
  'tls.client.x509.subject.common_name': {
    type: 'keyword',
    array: true,
    required: false
  },
  'tls.client.x509.subject.country': {
    type: 'keyword',
    array: true,
    required: false
  },
  'tls.client.x509.subject.distinguished_name': {
    type: 'keyword',
    array: false,
    required: false
  },
  'tls.client.x509.subject.locality': {
    type: 'keyword',
    array: true,
    required: false
  },
  'tls.client.x509.subject.organization': {
    type: 'keyword',
    array: true,
    required: false
  },
  'tls.client.x509.subject.organizational_unit': {
    type: 'keyword',
    array: true,
    required: false
  },
  'tls.client.x509.subject.state_or_province': {
    type: 'keyword',
    array: true,
    required: false
  },
  'tls.client.x509.version_number': {
    type: 'keyword',
    array: false,
    required: false
  },
  'tls.curve': {
    type: 'keyword',
    array: false,
    required: false
  },
  'tls.established': {
    type: 'boolean',
    array: false,
    required: false
  },
  'tls.next_protocol': {
    type: 'keyword',
    array: false,
    required: false
  },
  'tls.resumed': {
    type: 'boolean',
    array: false,
    required: false
  },
  'tls.server.certificate': {
    type: 'keyword',
    array: false,
    required: false
  },
  'tls.server.certificate_chain': {
    type: 'keyword',
    array: true,
    required: false
  },
  'tls.server.hash.md5': {
    type: 'keyword',
    array: false,
    required: false
  },
  'tls.server.hash.sha1': {
    type: 'keyword',
    array: false,
    required: false
  },
  'tls.server.hash.sha256': {
    type: 'keyword',
    array: false,
    required: false
  },
  'tls.server.issuer': {
    type: 'keyword',
    array: false,
    required: false
  },
  'tls.server.ja3s': {
    type: 'keyword',
    array: false,
    required: false
  },
  'tls.server.not_after': {
    type: 'date',
    array: false,
    required: false
  },
  'tls.server.not_before': {
    type: 'date',
    array: false,
    required: false
  },
  'tls.server.subject': {
    type: 'keyword',
    array: false,
    required: false
  },
  'tls.server.x509.alternative_names': {
    type: 'keyword',
    array: true,
    required: false
  },
  'tls.server.x509.issuer.common_name': {
    type: 'keyword',
    array: true,
    required: false
  },
  'tls.server.x509.issuer.country': {
    type: 'keyword',
    array: true,
    required: false
  },
  'tls.server.x509.issuer.distinguished_name': {
    type: 'keyword',
    array: false,
    required: false
  },
  'tls.server.x509.issuer.locality': {
    type: 'keyword',
    array: true,
    required: false
  },
  'tls.server.x509.issuer.organization': {
    type: 'keyword',
    array: true,
    required: false
  },
  'tls.server.x509.issuer.organizational_unit': {
    type: 'keyword',
    array: true,
    required: false
  },
  'tls.server.x509.issuer.state_or_province': {
    type: 'keyword',
    array: true,
    required: false
  },
  'tls.server.x509.not_after': {
    type: 'date',
    array: false,
    required: false
  },
  'tls.server.x509.not_before': {
    type: 'date',
    array: false,
    required: false
  },
  'tls.server.x509.public_key_algorithm': {
    type: 'keyword',
    array: false,
    required: false
  },
  'tls.server.x509.public_key_curve': {
    type: 'keyword',
    array: false,
    required: false
  },
  'tls.server.x509.public_key_exponent': {
    type: 'long',
    array: false,
    required: false
  },
  'tls.server.x509.public_key_size': {
    type: 'long',
    array: false,
    required: false
  },
  'tls.server.x509.serial_number': {
    type: 'keyword',
    array: false,
    required: false
  },
  'tls.server.x509.signature_algorithm': {
    type: 'keyword',
    array: false,
    required: false
  },
  'tls.server.x509.subject.common_name': {
    type: 'keyword',
    array: true,
    required: false
  },
  'tls.server.x509.subject.country': {
    type: 'keyword',
    array: true,
    required: false
  },
  'tls.server.x509.subject.distinguished_name': {
    type: 'keyword',
    array: false,
    required: false
  },
  'tls.server.x509.subject.locality': {
    type: 'keyword',
    array: true,
    required: false
  },
  'tls.server.x509.subject.organization': {
    type: 'keyword',
    array: true,
    required: false
  },
  'tls.server.x509.subject.organizational_unit': {
    type: 'keyword',
    array: true,
    required: false
  },
  'tls.server.x509.subject.state_or_province': {
    type: 'keyword',
    array: true,
    required: false
  },
  'tls.server.x509.version_number': {
    type: 'keyword',
    array: false,
    required: false
  },
  'tls.version': {
    type: 'keyword',
    array: false,
    required: false
  },
  'tls.version_protocol': {
    type: 'keyword',
    array: false,
    required: false
  },
  'trace.id': {
    type: 'keyword',
    array: false,
    required: false
  },
  'transaction.id': {
    type: 'keyword',
    array: false,
    required: false
  },
  'url.domain': {
    type: 'keyword',
    array: false,
    required: false
  },
  'url.extension': {
    type: 'keyword',
    array: false,
    required: false
  },
  'url.fragment': {
    type: 'keyword',
    array: false,
    required: false
  },
  'url.full': {
    type: 'wildcard',
    array: false,
    required: false
  },
  'url.original': {
    type: 'wildcard',
    array: false,
    required: false
  },
  'url.password': {
    type: 'keyword',
    array: false,
    required: false
  },
  'url.path': {
    type: 'wildcard',
    array: false,
    required: false
  },
  'url.port': {
    type: 'long',
    array: false,
    required: false
  },
  'url.query': {
    type: 'keyword',
    array: false,
    required: false
  },
  'url.registered_domain': {
    type: 'keyword',
    array: false,
    required: false
  },
  'url.scheme': {
    type: 'keyword',
    array: false,
    required: false
  },
  'url.subdomain': {
    type: 'keyword',
    array: false,
    required: false
  },
  'url.top_level_domain': {
    type: 'keyword',
    array: false,
    required: false
  },
  'url.username': {
    type: 'keyword',
    array: false,
    required: false
  },
  'user.changes.domain': {
    type: 'keyword',
    array: false,
    required: false
  },
  'user.changes.email': {
    type: 'keyword',
    array: false,
    required: false
  },
  'user.changes.full_name': {
    type: 'keyword',
    array: false,
    required: false
  },
  'user.changes.group.domain': {
    type: 'keyword',
    array: false,
    required: false
  },
  'user.changes.group.id': {
    type: 'keyword',
    array: false,
    required: false
  },
  'user.changes.group.name': {
    type: 'keyword',
    array: false,
    required: false
  },
  'user.changes.hash': {
    type: 'keyword',
    array: false,
    required: false
  },
  'user.changes.id': {
    type: 'keyword',
    array: false,
    required: false
  },
  'user.changes.name': {
    type: 'keyword',
    array: false,
    required: false
  },
  'user.changes.roles': {
    type: 'keyword',
    array: true,
    required: false
  },
  'user.domain': {
    type: 'keyword',
    array: false,
    required: false
  },
  'user.effective.domain': {
    type: 'keyword',
    array: false,
    required: false
  },
  'user.effective.email': {
    type: 'keyword',
    array: false,
    required: false
  },
  'user.effective.full_name': {
    type: 'keyword',
    array: false,
    required: false
  },
  'user.effective.group.domain': {
    type: 'keyword',
    array: false,
    required: false
  },
  'user.effective.group.id': {
    type: 'keyword',
    array: false,
    required: false
  },
  'user.effective.group.name': {
    type: 'keyword',
    array: false,
    required: false
  },
  'user.effective.hash': {
    type: 'keyword',
    array: false,
    required: false
  },
  'user.effective.id': {
    type: 'keyword',
    array: false,
    required: false
  },
  'user.effective.name': {
    type: 'keyword',
    array: false,
    required: false
  },
  'user.effective.roles': {
    type: 'keyword',
    array: true,
    required: false
  },
  'user.email': {
    type: 'keyword',
    array: false,
    required: false
  },
  'user.full_name': {
    type: 'keyword',
    array: false,
    required: false
  },
  'user.group.domain': {
    type: 'keyword',
    array: false,
    required: false
  },
  'user.group.id': {
    type: 'keyword',
    array: false,
    required: false
  },
  'user.group.name': {
    type: 'keyword',
    array: false,
    required: false
  },
  'user.hash': {
    type: 'keyword',
    array: false,
    required: false
  },
  'user.id': {
    type: 'keyword',
    array: false,
    required: false
  },
  'user.name': {
    type: 'keyword',
    array: false,
    required: false
  },
  'user.risk.calculated_level': {
    type: 'keyword',
    array: false,
    required: false
  },
  'user.risk.calculated_score': {
    type: 'float',
    array: false,
    required: false
  },
  'user.risk.calculated_score_norm': {
    type: 'float',
    array: false,
    required: false
  },
  'user.risk.static_level': {
    type: 'keyword',
    array: false,
    required: false
  },
  'user.risk.static_score': {
    type: 'float',
    array: false,
    required: false
  },
  'user.risk.static_score_norm': {
    type: 'float',
    array: false,
    required: false
  },
  'user.roles': {
    type: 'keyword',
    array: true,
    required: false
  },
  'user.target.domain': {
    type: 'keyword',
    array: false,
    required: false
  },
  'user.target.email': {
    type: 'keyword',
    array: false,
    required: false
  },
  'user.target.full_name': {
    type: 'keyword',
    array: false,
    required: false
  },
  'user.target.group.domain': {
    type: 'keyword',
    array: false,
    required: false
  },
  'user.target.group.id': {
    type: 'keyword',
    array: false,
    required: false
  },
  'user.target.group.name': {
    type: 'keyword',
    array: false,
    required: false
  },
  'user.target.hash': {
    type: 'keyword',
    array: false,
    required: false
  },
  'user.target.id': {
    type: 'keyword',
    array: false,
    required: false
  },
  'user.target.name': {
    type: 'keyword',
    array: false,
    required: false
  },
  'user.target.roles': {
    type: 'keyword',
    array: true,
    required: false
  },
  'user_agent.device.name': {
    type: 'keyword',
    array: false,
    required: false
  },
  'user_agent.name': {
    type: 'keyword',
    array: false,
    required: false
  },
  'user_agent.original': {
    type: 'keyword',
    array: false,
    required: false
  },
  'user_agent.os.family': {
    type: 'keyword',
    array: false,
    required: false
  },
  'user_agent.os.full': {
    type: 'keyword',
    array: false,
    required: false
  },
  'user_agent.os.kernel': {
    type: 'keyword',
    array: false,
    required: false
  },
  'user_agent.os.name': {
    type: 'keyword',
    array: false,
    required: false
  },
  'user_agent.os.platform': {
    type: 'keyword',
    array: false,
    required: false
  },
  'user_agent.os.type': {
    type: 'keyword',
    array: false,
    required: false
  },
  'user_agent.os.version': {
    type: 'keyword',
    array: false,
    required: false
  },
  'user_agent.version': {
    type: 'keyword',
    array: false,
    required: false
  },
  'vulnerability.category': {
    type: 'keyword',
    array: true,
    required: false
  },
  'vulnerability.classification': {
    type: 'keyword',
    array: false,
    required: false
  },
  'vulnerability.description': {
    type: 'keyword',
    array: false,
    required: false
  },
  'vulnerability.enumeration': {
    type: 'keyword',
    array: false,
    required: false
  },
  'vulnerability.id': {
    type: 'keyword',
    array: false,
    required: false
  },
  'vulnerability.reference': {
    type: 'keyword',
    array: false,
    required: false
  },
  'vulnerability.report_id': {
    type: 'keyword',
    array: false,
    required: false
  },
  'vulnerability.scanner.vendor': {
    type: 'keyword',
    array: false,
    required: false
  },
  'vulnerability.score.base': {
    type: 'float',
    array: false,
    required: false
  },
  'vulnerability.score.environmental': {
    type: 'float',
    array: false,
    required: false
  },
  'vulnerability.score.temporal': {
    type: 'float',
    array: false,
    required: false
  },
  'vulnerability.score.version': {
    type: 'keyword',
    array: false,
    required: false
  },
  'vulnerability.severity': {
    type: 'keyword',
    array: false,
    required: false
  }
};
exports.ecsFieldMap = ecsFieldMap;