"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.addPrepackagedRulesSchema = void 0;

var t = _interopRequireWildcard(require("io-ts"));

var _securitysolutionIoTsTypes = require("@kbn/securitysolution-io-ts-types");

var _common = require("../common");

var _rule_schemas = require("./rule_schemas");

function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }

function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Big differences between this schema and the createRulesSchema
 *  - rule_id is required here
 *  - version is a required field that must exist
 */
const addPrepackagedRulesSchema = t.intersection([_rule_schemas.baseCreateParams, _rule_schemas.createTypeSpecific, // version is required in addPrepackagedRulesSchema, so this supercedes the defaultable
// version in baseParams
t.exact(t.type({
  rule_id: _common.rule_id,
  version: _securitysolutionIoTsTypes.version
})), t.exact(t.partial({
  related_integrations: _common.RelatedIntegrationArray,
  required_fields: _common.RequiredFieldArray,
  setup: _common.SetupGuide
}))]);
exports.addPrepackagedRulesSchema = addPrepackagedRulesSchema;