"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getEndpointAuthzInitialState = exports.calculateEndpointAuthz = void 0;

/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Used by both the server and the UI to generate the Authorization for access to Endpoint related
 * functionality
 *
 * @param licenseService
 * @param fleetAuthz
 * @param userRoles
 */
const calculateEndpointAuthz = (licenseService, fleetAuthz, userRoles) => {
  var _fleetAuthz$fleet$all;

  const isPlatinumPlusLicense = licenseService.isPlatinumPlus();
  const isEnterpriseLicense = licenseService.isEnterprise();
  const hasEndpointManagementAccess = userRoles.includes('superuser');
  return {
    canAccessFleet: (_fleetAuthz$fleet$all = fleetAuthz === null || fleetAuthz === void 0 ? void 0 : fleetAuthz.fleet.all) !== null && _fleetAuthz$fleet$all !== void 0 ? _fleetAuthz$fleet$all : userRoles.includes('superuser'),
    canAccessEndpointManagement: hasEndpointManagementAccess,
    canCreateArtifactsByPolicy: hasEndpointManagementAccess && isPlatinumPlusLicense,
    // Response Actions
    canIsolateHost: isPlatinumPlusLicense && hasEndpointManagementAccess,
    canUnIsolateHost: hasEndpointManagementAccess,
    canKillProcess: hasEndpointManagementAccess && isEnterpriseLicense,
    canSuspendProcess: hasEndpointManagementAccess && isEnterpriseLicense,
    canGetRunningProcesses: hasEndpointManagementAccess && isEnterpriseLicense,
    canAccessResponseConsole: hasEndpointManagementAccess && isEnterpriseLicense,
    canAccessResponseActionsHistory: hasEndpointManagementAccess && isEnterpriseLicense
  };
};

exports.calculateEndpointAuthz = calculateEndpointAuthz;

const getEndpointAuthzInitialState = () => {
  return {
    canAccessFleet: false,
    canAccessEndpointManagement: false,
    canCreateArtifactsByPolicy: false,
    canIsolateHost: false,
    canUnIsolateHost: true,
    canKillProcess: false,
    canSuspendProcess: false,
    canGetRunningProcesses: false,
    canAccessResponseConsole: false,
    canAccessResponseActionsHistory: false
  };
};

exports.getEndpointAuthzInitialState = getEndpointAuthzInitialState;