"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.findRuleExceptionReferencesRoute = void 0;

var _securitysolutionEsUtils = require("@kbn/securitysolution-es-utils");

var _securitysolutionListUtils = require("@kbn/securitysolution-list-utils");

var _securitysolutionIoTsUtils = require("@kbn/securitysolution-io-ts-utils");

var _constants = require("../../../../../common/constants");

var _utils = require("../utils");

var _enrich_filter_with_rule_type_mappings = require("../../rules/enrich_filter_with_rule_type_mappings");

var _find_exception_list_references_schema = require("../../../../../common/detection_engine/schemas/request/find_exception_list_references_schema");

var _route_validation = require("../../../../utils/build_validation/route_validation");

var _find_exception_list_references_schema2 = require("../../../../../common/detection_engine/schemas/response/find_exception_list_references_schema");

/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const findRuleExceptionReferencesRoute = router => {
  router.get({
    path: _constants.DETECTION_ENGINE_RULES_EXCEPTIONS_REFERENCE_URL,
    validate: {
      query: (0, _route_validation.buildRouteValidation)(_find_exception_list_references_schema.findExceptionReferencesOnRuleSchema)
    },
    options: {
      tags: ['access:securitySolution']
    }
  }, async (context, request, response) => {
    const siemResponse = (0, _utils.buildSiemResponse)(response);

    try {
      const {
        ids,
        namespace_types: namespaceTypes,
        list_ids: listIds
      } = request.query;
      const ctx = await context.resolve(['core', 'securitySolution', 'alerting']);
      const rulesClient = ctx.alerting.getRulesClient();

      if (ids.length !== namespaceTypes.length || ids.length !== listIds.length) {
        return siemResponse.error({
          body: `"ids", "list_ids" and "namespace_types" need to have the same comma separated number of values. Expected "ids" length: ${ids.length} to equal "namespace_types" length: ${namespaceTypes.length} and "list_ids" length: ${listIds.length}.`,
          statusCode: 400
        });
      }

      const foundRules = await Promise.all(ids.map(async (id, index) => {
        return rulesClient.find({
          options: {
            perPage: 10000,
            filter: (0, _enrich_filter_with_rule_type_mappings.enrichFilterWithRuleTypeMapping)(null),
            hasReference: {
              id,
              type: (0, _securitysolutionListUtils.getSavedObjectType)({
                namespaceType: namespaceTypes[index]
              })
            }
          }
        });
      }));
      const references = foundRules.map(({
        data
      }, index) => {
        const wantedData = data.map(({
          name,
          id,
          params
        }) => ({
          name,
          id,
          rule_id: params.ruleId,
          exception_lists: params.exceptionsList
        }));
        return {
          [listIds[index]]: wantedData
        };
      });
      const [validated, errors] = (0, _securitysolutionIoTsUtils.validate)({
        references
      }, _find_exception_list_references_schema2.rulesReferencedByExceptionListsSchema);

      if (errors != null) {
        return siemResponse.error({
          statusCode: 500,
          body: errors
        });
      } else {
        return response.ok({
          body: validated !== null && validated !== void 0 ? validated : {
            references: []
          }
        });
      }
    } catch (err) {
      const error = (0, _securitysolutionEsUtils.transformError)(err);
      return siemResponse.error({
        body: error.message,
        statusCode: error.statusCode
      });
    }
  });
};

exports.findRuleExceptionReferencesRoute = findRuleExceptionReferencesRoute;