"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.bulkEditActionToRulesClientOperation = void 0;

var _perform_bulk_action_schema = require("../../../../../common/detection_engine/schemas/request/perform_bulk_action_schema");

var _utility_types = require("../../../../../common/utility_types");

var _utils = require("../utils");

/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const getThrottleOperation = throttle => ({
  field: 'throttle',
  operation: 'set',
  value: (0, _utils.transformToAlertThrottle)(throttle)
});

const getNotifyWhenOperation = throttle => ({
  field: 'notifyWhen',
  operation: 'set',
  value: (0, _utils.transformToNotifyWhen)(throttle)
});
/**
 * converts bulk edit action to format of rulesClient.bulkEdit operation
 * @param action BulkActionEditForRuleAttributes
 * @returns rulesClient BulkEditOperation
 */


const bulkEditActionToRulesClientOperation = action => {
  switch (action.type) {
    // tags actions
    case _perform_bulk_action_schema.BulkActionEditType.add_tags:
      return [{
        field: 'tags',
        operation: 'add',
        value: action.value
      }];

    case _perform_bulk_action_schema.BulkActionEditType.delete_tags:
      return [{
        field: 'tags',
        operation: 'delete',
        value: action.value
      }];

    case _perform_bulk_action_schema.BulkActionEditType.set_tags:
      return [{
        field: 'tags',
        operation: 'set',
        value: action.value
      }];
    // rule actions

    case _perform_bulk_action_schema.BulkActionEditType.add_rule_actions:
      return [{
        field: 'actions',
        operation: 'add',
        value: action.value.actions
      }, getThrottleOperation(action.value.throttle), getNotifyWhenOperation(action.value.throttle)];

    case _perform_bulk_action_schema.BulkActionEditType.set_rule_actions:
      return [{
        field: 'actions',
        operation: 'set',
        value: action.value.actions
      }, getThrottleOperation(action.value.throttle), getNotifyWhenOperation(action.value.throttle)];
    // schedule actions

    case _perform_bulk_action_schema.BulkActionEditType.set_schedule:
      return [{
        field: 'schedule',
        operation: 'set',
        value: {
          interval: action.value.interval
        }
      }];

    default:
      return (0, _utility_types.assertUnreachable)(action);
  }
};

exports.bulkEditActionToRulesClientOperation = bulkEditActionToRulesClientOperation;