"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createIndex = exports.createEsIndexBodySchema = void 0;

var _configSchema = require("@kbn/config-schema");

/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const createEsIndexBodySchema = _configSchema.schema.object({
  index: _configSchema.schema.string({
    minLength: 1
  }),
  mappings: _configSchema.schema.maybe(_configSchema.schema.recordOf(_configSchema.schema.string({
    minLength: 1
  }), _configSchema.schema.any()))
});

exports.createEsIndexBodySchema = createEsIndexBodySchema;

const createIndex = async ({
  client,
  options
}) => {
  await client.asCurrentUser.indices.create(options);
};

exports.createIndex = createIndex;