"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "CasesWebhookConnectorTypeId", {
  enumerable: true,
  get: function () {
    return _cases.CasesWebhookConnectorTypeId;
  }
});
Object.defineProperty(exports, "EmailConnectorTypeId", {
  enumerable: true,
  get: function () {
    return _stack.EmailConnectorTypeId;
  }
});
Object.defineProperty(exports, "IndexConnectorTypeId", {
  enumerable: true,
  get: function () {
    return _stack.IndexConnectorTypeId;
  }
});
Object.defineProperty(exports, "JiraConnectorTypeId", {
  enumerable: true,
  get: function () {
    return _cases.JiraConnectorTypeId;
  }
});
Object.defineProperty(exports, "PagerDutyConnectorTypeId", {
  enumerable: true,
  get: function () {
    return _stack.PagerDutyConnectorTypeId;
  }
});
Object.defineProperty(exports, "ResilientConnectorTypeId", {
  enumerable: true,
  get: function () {
    return _cases.ResilientConnectorTypeId;
  }
});
Object.defineProperty(exports, "ServerLogConnectorTypeId", {
  enumerable: true,
  get: function () {
    return _stack.ServerLogConnectorTypeId;
  }
});
Object.defineProperty(exports, "ServiceNowITOMConnectorTypeId", {
  enumerable: true,
  get: function () {
    return _cases.ServiceNowITOMConnectorTypeId;
  }
});
Object.defineProperty(exports, "ServiceNowITSMConnectorTypeId", {
  enumerable: true,
  get: function () {
    return _cases.ServiceNowITSMConnectorTypeId;
  }
});
Object.defineProperty(exports, "ServiceNowSIRConnectorTypeId", {
  enumerable: true,
  get: function () {
    return _cases.ServiceNowSIRConnectorTypeId;
  }
});
Object.defineProperty(exports, "SlackConnectorTypeId", {
  enumerable: true,
  get: function () {
    return _stack.SlackConnectorTypeId;
  }
});
Object.defineProperty(exports, "TeamsConnectorTypeId", {
  enumerable: true,
  get: function () {
    return _stack.TeamsConnectorTypeId;
  }
});
Object.defineProperty(exports, "WebhookConnectorTypeId", {
  enumerable: true,
  get: function () {
    return _stack.WebhookConnectorTypeId;
  }
});
Object.defineProperty(exports, "XmattersConnectorTypeId", {
  enumerable: true,
  get: function () {
    return _cases.XmattersConnectorTypeId;
  }
});
exports.registerConnectorTypes = registerConnectorTypes;

var _stack = require("./stack");

var _cases = require("./cases");

/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function registerConnectorTypes({
  actions,
  logger,
  publicBaseUrl
}) {
  actions.registerType((0, _stack.getEmailConnectorType)({
    logger,
    publicBaseUrl
  }));
  actions.registerType((0, _stack.getIndexConnectorType)({
    logger
  }));
  actions.registerType((0, _stack.getPagerDutyConnectorType)({
    logger
  }));
  actions.registerType((0, _cases.getSwimlaneConnectorType)({
    logger
  }));
  actions.registerType((0, _stack.getServerLogConnectorType)({
    logger
  }));
  actions.registerType((0, _stack.getSlackConnectorType)({
    logger
  }));
  actions.registerType((0, _stack.getWebhookConnectorType)({
    logger
  }));
  actions.registerType((0, _cases.getCasesWebhookConnectorType)({
    logger
  }));
  actions.registerType((0, _cases.getXmattersConnectorType)({
    logger
  }));
  actions.registerType((0, _cases.getServiceNowITSMConnectorType)({
    logger
  }));
  actions.registerType((0, _cases.getServiceNowSIRConnectorType)({
    logger
  }));
  actions.registerType((0, _cases.getServiceNowITOMConnectorType)({
    logger
  }));
  actions.registerType((0, _cases.getJiraConnectorType)({
    logger
  }));
  actions.registerType((0, _cases.getResilientConnectorType)({
    logger
  }));
  actions.registerType((0, _stack.getTeamsConnectorType)({
    logger
  }));
}