"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getCerts = void 0;

var _get_certs_request_body = require("../../../../common/requests/get_certs_request_body");

/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const getCerts = async requestParams => {
  const result = await getCertsResults(requestParams);
  return (0, _get_certs_request_body.processCertsResult)(result);
};

exports.getCerts = getCerts;

const getCertsResults = async requestParams => {
  const {
    uptimeEsClient
  } = requestParams;
  const searchBody = (0, _get_certs_request_body.getCertsRequestBody)(requestParams);
  const request = {
    body: searchBody
  };
  const {
    body: result
  } = await uptimeEsClient.search({
    body: searchBody
  });
  return result;
};