#!/bin/sh
# Copyright start
# Copyright (C) 2008 - 2024 Fortinet Inc.
# All rights reserved.
# FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE
# Copyright end

set -x

name='cyops-archival'
prefix=/opt/$name

restorecon -R $prefix

### Post-upgrade Actions

### Common Actions
ln -sf /etc/pki/cyops/archivalpublic.key $prefix/archival/configs/
ln -sf /etc/pki/cyops/archivalprivate.key $prefix/archival/configs/

# Migrate database
cd $prefix/archival
sudo -u nginx $prefix/.env/bin/python3 manage.py migrate > /dev/null
restorecon -R $prefix
restorecon -R /etc/
systemctl start nginx
systemctl start uwsgi

# Set selinux user system_u
semanage fcontext -a -s system_u -t var_log_t "/var/log/cyops/cyops-archival" 2>/dev/null
restorecon -rvF /var/log/cyops/cyops-archival
