#!/bin/sh
# Copyright start
# Copyright (C) 2008 - 2024 Fortinet Inc.
# All rights reserved.
# FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE
# Copyright end

set -x

API_CONF='/etc/nginx/conf.d/cyops-api.conf'
WORKFLOW_CONF='/etc/nginx/conf.d/cyops-workflow.conf'
INTEGRATIONS_CONF='/etc/nginx/conf.d/cyops-integrations.conf'
POSTMAN_CONF='/etc/nginx/conf.d/cyops-routing-agent.conf'
ARCHIVAL_CONF='/etc/nginx/conf.d/cyops-archival.conf'

sed -i '/listen/d' /etc/nginx/conf.d/cyops*.conf

ip addr | grep 'inet6 ::1/' &> /dev/null
ip6enabled=$?
ip addr | grep 'inet ' &> /dev/null
ip4enabled=$?

if [ "$ip6enabled" -eq 0 ]; then
    sed -i '0,/server/a \    listen [::]:443 ssl;' $API_CONF
    sed -i '0,/server/a \    listen [::1]:8888 ssl;' $WORKFLOW_CONF
    sed -i '0,/server/a \    listen [::1]:9595 ssl;' $INTEGRATIONS_CONF
    sed -i '0,/server/a \    listen [::1]:7575 ssl;' $POSTMAN_CONF
    sed -i '0,/server/a \    listen [::1]:7564 ssl;' $ARCHIVAL_CONF
fi

if [ "$ip4enabled" -eq 0 ]; then
    sed -i '0,/server/a \    listen 443 ssl;' $API_CONF
    sed -i '0,/server/a \    listen 127.0.0.1:8888 ssl;' $WORKFLOW_CONF
    sed -i '0,/server/a \    listen 127.0.0.1:9595 ssl;' $INTEGRATIONS_CONF
    sed -i '0,/server/a \    listen 127.0.0.1:7575 ssl;' $POSTMAN_CONF
    sed -i '0,/server/a \    listen 127.0.0.1:7564 ssl;' $ARCHIVAL_CONF
fi


exit 0
