""" Copyright start
  Copyright (C) 2008 - 2025 Fortinet Inc.
  All rights reserved.
  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE
  Copyright end """
import subprocess

from framework.base.tasks import Tasks
from helpers.cmd_utils import CmdUtils
from helpers.logger import Logger
from constants import FRAMEWORK_PATH, LOG_FILE, REPORT_FILE, STEP_RESULT_FILE, TASK_STATUS, TASK_LOG_STATUS, TEXT_COLOR, TEXT_DECORATION


class AddCspHeader(Tasks):
    """Implementation class for tasks"""
    
    def __init__(self) -> None:
        super().__init__()
        self.logger = Logger.get_logger(__name__)
        self.cmd_line_utilities = CmdUtils()
        self.store_result_path = STEP_RESULT_FILE.format(self.target_upgrade_version)
        self.report_path = REPORT_FILE.format(self.target_upgrade_version)

    @property
    def tags(self) -> str:
        """Tags for task"""
        return 'post_upgrade'

    
    def get_description(self) -> str:
        """Description of a method"""
        return "Add CSP Header"

    
    def is_supported(self) -> bool:
        """To check task is for target upgrade version/platform"""
        current_version = int(self.current_version.replace('.', ''))
        target_upgrade_version = int(self.target_upgrade_version.replace('.', ''))
        return target_upgrade_version >= current_version


    def execute(self) -> None:
        """To execute main code"""
        step_result = self.get_step_results('pre-upgrade', 'initialize')
        flag_is_enterprise = step_result['flag_is_enterprise']
        if flag_is_enterprise:
            cmd = "grep -qi 'Content-Security-Policy' /etc/nginx/conf.d/cyops-api.conf && echo 'found' || echo 'not_found'"
            result = self.execute_cmd(cmd)
            if str(result.get("std_out", "")) == "not_found":
                self.logger.info("adding CSP headers in /etc/nginx/conf.d/cyops-api.conf")
                cmd = "sed -i '/ssl_session_tickets off;/a\    add_header Content-Security-Policy \"default-src 'self';\" always;' /etc/nginx/conf.d/cyops-api.conf"
                self.execute_cmd(cmd)

    def execute_cmd(self, cmd):
        ret_dict = {
            'return_code': 1,
            'std_out': "",
            'std_err': ""
        }
        try:
            pipes = subprocess.Popen(cmd, stdout=subprocess.PIPE, stderr=subprocess.PIPE, shell=True)
            std_out, std_err = pipes.communicate()
            ret_dict['return_code'] = pipes.returncode
            ret_dict['std_out'] = std_out.strip().decode("utf-8")
            ret_dict['std_err'] = std_err.strip().decode("utf-8")
            return ret_dict
        except Exception as e:
            self.logger.exception(f"execution of command {cmd} failed. Error: {str(e)}")
            return ret_dict
    
    def validate(self) -> bool:
        """Write validations in this function"""
        return True

    
    def _print_status_msg(self, msg:str, status:str) -> None:
        """Use this function to print status message of task execution"""
        reset = TEXT_COLOR["RESET"]
        if status == TASK_STATUS["DONE"]:
            color = TEXT_COLOR["GREEN"]
        else:
            color = TEXT_COLOR["RED"]
        truncated_message = msg[:65] + "..." if len(msg) > 65 else msg
        width = 8
        status = f"{status:^{width}}"
        colored_status = f"{color}{status}{reset}"
        final_msg = "{:<70}{}[{}]".format(truncated_message," ",colored_status)
        print(final_msg)
