""" Copyright start
  Copyright (C) 2008 - 2024 Fortinet Inc.
  All rights reserved.
  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE
  Copyright end """

import os
import json
from framework.base.tasks import Tasks
from constants import EXECUTE_STATUS_FILE

class DeleteOldStatusFile(Tasks):
    def __init__(self) -> None:
        super().__init__()
        
    @property
    def tags(self) -> str:
        return 'pre-upgrade'

    def get_description(self) -> str:
        return ""

    def is_supported(self) -> bool:
        return True

    def execute(self):
        pass

    def validate(self) -> bool:
        if os.path.isfile(EXECUTE_STATUS_FILE):
            with open(EXECUTE_STATUS_FILE,'r') as file:
                file_data = json.load(file)
            file_data_version = file_data.get("version",None)
            if file_data_version != self.target_upgrade_version:
                os.system(f"rm -f {EXECUTE_STATUS_FILE}")
        return True