#!/bin/sh
# Copyright start
# Copyright (C) 2008 - 2024 Fortinet Inc.
# All rights reserved.
# FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE
# Copyright end

set -x

name='cyops-workflow'
prefix=/opt/$name

### Post-upgrade Actions
systemctl enable fsr-workflow

# uwsgi rpm sets uwsgi:uwsgi ownership to /var/run/uwsgi
# but service start fails as we need nginx ownership on it
chown nginx:nginx /var/run/uwsgi
mv /etc/uwsgi.ini /etc/uwsgi.ini.bak
yes | cp /opt/cyops/configs/uwsgi/uwsgi.ini /etc/
yes | cp /opt/cyops/configs/uwsgi/uwsgi.service /usr/lib/systemd/system/

# Deactivate
restorecon -R $prefix

# Migrate database
cd $prefix/sealab
sudo -u nginx $prefix/.env/bin/python3 manage.py migrate
sudo -u nginx $prefix/.env/bin/python3 manage.py createcachetable

# Collect assets
sudo -u nginx $prefix/.env/bin/python3 manage.py collectstatic --no-input

# Import inbuild global variables
sudo -u nginx $prefix/.env/bin/python3 manage.py global_variables

# Migrate Config File from config.py to config.ini
sudo -u nginx $prefix/.env/bin/python3 manage.py migrate_config

# Create default schedules
sudo -u nginx $prefix/.env/bin/python3 manage.py default_schedules --upgrade

# Create custom jinja functions, if available
sudo -u nginx $prefix/.env/bin/python3 manage.py populate_custom_functions

# Add new parameters to config.ini when upgrading
sudo -u nginx $prefix/.env/bin/python3 manage.py merge_config

# update celerybeatd config
sed -i "s/Type=forking/Type=simple/g"  /usr/lib/systemd/system/celerybeatd.service
restorecon -R $prefix
restorecon -R /etc/
restorecon -R /usr/
systemctl daemon-reload
systemctl enable uwsgi
systemctl restart nginx
systemctl restart uwsgi
systemctl restart celeryd
systemctl restart celerybeatd
systemctl restart fsr-workflow

### Common Actions
# Create default jinja functions, needs to be run in case of fresh install and upgrade
sudo -u nginx $prefix/.env/bin/python3 manage.py populate_functions

# Set selinux user system_u
semanage fcontext -a -s system_u -t var_log_t "/var/log/cyops/cyops-workflow" 2>/dev/null
restorecon -rvF /var/log/cyops/cyops-workflow