""" Copyright start
  Copyright (C) 2008 - 2025 Fortinet Inc.
  All rights reserved.
  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE
  Copyright end """

import os
import sys
from framework.base.tasks import Tasks

TASK_STATUS = {"DONE":"DONE", "FAILED":"FAILED"}
TASK_LOG_STATUS = {"STARTED":"STARTED","COMPLETED":"COMPLETED"}
TEXT_COLOR = {'GREEN':'\033[92m', 'RED':'\033[91m', 'YELLOW':'\033[93m', 'RESET':'\033[0m'}
TEXT_DECORATION = {'BLINK':'\033[5m', 'BOLD':'\033[1m','RESET':'\033[0m'}

# This task is only for upgrade from 7.5.0 to 7.6.0. 
# For upgrades from 7.6.0 to further releases, same check is added in main.py
class VerifyDockerInstance(Tasks):
    MSG_WIDTH = 80
    SPACE_BEFORE_MSG = 2
    PHASE_START_MSG = "Started executing {0} phase."
    PHASE_END_MSG = "Completed execution of {0} phase."
    DOCKER_INSTANCE_UPGRADE_MSG = "{0}The 'csadm upgrade execute' command cannot be used to upgrade FortiSOAR on Docker.\nPlease refer to the FortiSOAR documentation for upgrade instructions.{1}"
    DOCKER_INSTANCE_MSG = "{0}{1}The 'csadm upgrade {2}' command cannot be used with Docker.{3}"

    def __init__(self) -> None:
        super().__init__()
        
    @property
    def tags(self) -> str:
        return 'pre-upgrade'

    def get_description(self) -> str:
        return ""

    def is_supported(self) -> bool:
        return self.current_version=='7.5.0'

    def execute(self):
        pass

    def validate(self) -> bool:
        new_line_char = "\n" if len(sys.argv) > 2 and sys.argv[1]!='execute-phase' else ""
        command = sys.argv[1] if len(sys.argv) > 2 and sys.argv[1]!='execute' else ""
        if self.is_docker():
            if command:
                print(self.DOCKER_INSTANCE_MSG.format(new_line_char,TEXT_COLOR["RED"],command,TEXT_COLOR["RESET"]))
            else:
                print(self.DOCKER_INSTANCE_UPGRADE_MSG.format(TEXT_COLOR["RED"],TEXT_COLOR["RESET"]))
            self._show_start_or_end_msg('preupgrade','end')
            sys.exit()
        return True

    def is_docker(self):
        flag_fsr_in_docker="/data/.do-not-delete-flag-fsr-in-docker"
        if os.path.exists(flag_fsr_in_docker):
            return True
        return False
    
    def _show_start_or_end_msg(self, phase, position=None):
        if position == 'start':
            msg = self.PHASE_START_MSG.format(phase)
        if position == 'end':
            msg = self.PHASE_END_MSG.format(phase)
        border = "="*(self.MSG_WIDTH+self.SPACE_BEFORE_MSG)
        final_msg = (" "*self.SPACE_BEFORE_MSG)+msg
        print("\n{}\n{}\n{}".format(border, final_msg, border))