#!/bin/sh
# Copyright start
# Copyright (C) 2008 - 2025 Fortinet Inc.
# All rights reserved.
# FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE
# Copyright end

set -x

name='cyops-auth'
prefix=/opt/$name

mkdir -p /var/log/cyops/cyops-auth
chown -R nginx:nginx /var/log/cyops/cyops-auth

# license management CLI
chmod a+x $prefix/utilities/licensemanager.py

# user management CLI
chmod a+x $prefix/utilities/usermanager.py

# ha management CLI
chmod a+x $prefix/utilities/ha/manager.py
chmod a+x $prefix/utilities/ha/cmd_executor.py
ln -sf $prefix/utilities/ha/manager.py /usr/bin/hamanager

### Post-upgrade Actions
cd $prefix
if ! grep -q "\[LOGGING\]" $prefix/utilities/das.ini; then
    sed -i -e '$a\\n[LOGGING]\nlevel = WARN\npath = /var/log/cyops/cyops-auth/das.log' $prefix/utilities/das.ini;
else
    sed -i 's;log_path = /var/log/cyops-auth/das.log;level = WARN\npath = /var/log/cyops/cyops-auth/das.log;g' $prefix/utilities/das.ini
fi
if ! grep -q "\[RABBITMQ\]" $prefix/utilities/das.ini; then
    sed -i -e '$a\\n[RABBITMQ]\nexchange_name = exchange.cyops.das\nexchange_type = direct\nrouting_key = key.das.event' $prefix/utilities/das.ini;
fi

sudo -u nginx PYTHONPATH=$prefix $prefix/.env/bin/python3 utilities/dasmigrate.py up

#license management CLI
chmod a+x $prefix/utilities/licensemanager.py
FILE=/etc/pki/cyops/archivalpublic.key
if [ ! -f "$FILE" ]; then
    # Generating Archival Keys used by both CH as well as Archival code
    # Can be removed once the minimal upgrade is 7.2.0
    $prefix/.env/bin/python3 $prefix/defaultappliance.py --app archival generate-app-keys
fi
systemctl daemon-reload
systemctl restart cyops-auth.service
systemctl restart cyops-ha.service

# Restore context
restorecon -R $prefix

### Common Actions
# Set selinux user system_u
semanage fcontext -a -s system_u -t var_log_t "/var/log/cyops/cyops-auth" 2>/dev/null
restorecon -rvF /var/log/cyops/cyops-auth