/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.authenticator.jaspic;

import jakarta.security.auth.message.callback.CallerPrincipalCallback;
import jakarta.security.auth.message.callback.GroupPrincipalCallback;
import jakarta.security.auth.message.callback.PasswordValidationCallback;
import java.io.IOException;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import org.apache.catalina.Contained;
import org.apache.catalina.Container;
import org.apache.catalina.realm.GenericPrincipal;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.res.StringManager;

public class CallbackHandlerImpl
implements CallbackHandler,
Contained {
    private static final StringManager sm = StringManager.getManager(CallbackHandlerImpl.class);
    private final Log log = LogFactory.getLog(CallbackHandlerImpl.class);
    private Container container;

    @Override
    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        String name = null;
        Principal principal = null;
        Subject subject = null;
        String[] groups = null;
        if (callbacks != null) {
            for (Callback callback : callbacks) {
                if (callback instanceof CallerPrincipalCallback) {
                    CallerPrincipalCallback cpc = (CallerPrincipalCallback)callback;
                    name = cpc.getName();
                    if (cpc.getPrincipal() != null) {
                        principal = cpc.getPrincipal();
                    }
                    subject = cpc.getSubject();
                    continue;
                }
                if (callback instanceof GroupPrincipalCallback) {
                    GroupPrincipalCallback gpc = (GroupPrincipalCallback)callback;
                    groups = gpc.getGroups();
                    continue;
                }
                if (callback instanceof PasswordValidationCallback) {
                    if (this.container == null) {
                        this.log.warn((Object)sm.getString("callbackHandlerImpl.containerMissing", new Object[]{callback.getClass().getName()}));
                        continue;
                    }
                    if (this.container.getRealm() == null) {
                        this.log.warn((Object)sm.getString("callbackHandlerImpl.realmMissing", new Object[]{callback.getClass().getName(), this.container.getName()}));
                        continue;
                    }
                    PasswordValidationCallback pvc = (PasswordValidationCallback)callback;
                    principal = this.container.getRealm().authenticate(pvc.getUsername(), String.valueOf(pvc.getPassword()));
                    pvc.setResult(principal != null);
                    subject = pvc.getSubject();
                    continue;
                }
                this.log.error((Object)sm.getString("callbackHandlerImpl.jaspicCallbackMissing", new Object[]{callback.getClass().getName()}));
            }
            if (subject != null) {
                if (name == null && principal != null) {
                    name = principal.getName();
                }
                if (name != null) {
                    if (principal instanceof GenericPrincipal) {
                        subject.getPrivateCredentials().add(principal);
                    } else {
                        ArrayList<String> mergedRoles = new ArrayList<String>();
                        Set<GenericPrincipal> gps = subject.getPrivateCredentials(GenericPrincipal.class);
                        if (!gps.isEmpty()) {
                            GenericPrincipal gp = gps.iterator().next();
                            mergedRoles.addAll(Arrays.asList(gp.getRoles()));
                            subject.getPrivateCredentials().remove(gp);
                        }
                        if (groups != null) {
                            mergedRoles.addAll(Arrays.asList(groups));
                        }
                        if (mergedRoles.size() == 0) {
                            mergedRoles = Collections.emptyList();
                        }
                        subject.getPrivateCredentials().add(new GenericPrincipal(name, mergedRoles, principal));
                    }
                }
            }
        }
    }

    @Override
    public Container getContainer() {
        return this.container;
    }

    @Override
    public void setContainer(Container container) {
        this.container = container;
    }
}

