#!/bin/sh
# Copyright start
# Copyright (C) 2008 - 2025 Fortinet Inc.
# All rights reserved.
# FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE
# Copyright end

set -x

store_to_json(){
    # This method can be used to store data in step_result.json
    # $1 is target fsr version which is passed to this file during execution. Pass $1 as it is as first argument while calling this function
    # $2 is to take phase_name
    # $3 is to take task_name
    # $4 is to take key for data to store in json
    # $5 is to take data to store in json
    json_file_path="/opt/fsr-elevate/elevate/outputs/step_result-$1.json"
    python3 -c "import sys; sys.path.append('/opt/fsr-elevate/elevate'); from framework.utility.task_utils import TaskUtilities; task_utils=TaskUtilities(); task_utils.store_result_to_json(\"$json_file_path\",\"$2\",\"$3\",\"$4\",\"$5\")"
}

get_data_from_json(){
    # This method can be used to get data from step_result.json
    # $1 is target fsr version which is passed to this file during execution. Pass $1 as it is as first argument while calling this function
    # $2 is to take phase_name
    # $3 is to take task_name
    # $4 is to take key in which data is stored
    target_version=$1
    
    json_file_path="/opt/fsr-elevate/elevate/outputs/step_result-$target_version.json"
    if [ $# = 1 ];then
        result=$(jq -r "" "$json_file_path")
    elif [ $# = 2 ];then
        key1=$2
        result=$(jq -r --arg key1 "$key1" '.[$key1]' "$json_file_path")
    elif [ $# = 3 ];then
        key1=$2
        key2=$3
        result=$(jq -r --arg key1 "$key1" --arg key2 "$key2" '.[$key1][$key2]' "$json_file_path")
    elif [ $# = 4 ];then
        key1=$2
        key2=$3
        key3=$4
        result=$(jq -r --arg key1 "$key1" --arg key2 "$key2" --arg key3 "$key3" '.[$key1][$key2][$key3]' "$json_file_path")
    else 
        result="Filter upto 3 level is supported. Provided more than 3 filter parameters in '$0'"
    fi
    if [ "${result}" = "null" ];then echo "Please provide valid filter key in '$0'."
    else echo "$result"
    fi
}

is_enterprise_instance=$(get_data_from_json "$1" 'pre-upgrade' 'initialize' 'flag_is_enterprise')
version=$1
build_number=$(get_data_from_json "$1" 'upgrade' 'upgrade' 'build_number')

# Need to use UTC for RTC
/bin/timedatectl set-local-rtc 0
. /opt/cyops/adm/utils

### Post-upgrade Actions

### Common Actions
install_semodules() {
    # space separated list of fortisoar semodules with .pp extension
    semodules="fortisoar-logrotate \
            fortisoar-phpfpm \
            fortisoar-phpfpm-allow-uc-svc-t \
            fortisoar-python3 \
            fortisoar-gunicorn \
            fortisoar-nginx \
            fortisoar-hostnamectl"
    semodules_top_dir_path="/opt/cyops/semodule/"
    for module in $semodules; do
        # semodule -i will install/replace specified module package
        module_path="$semodules_top_dir_path/${module}.pp"
        echo "Installing semodule [$module_path]"
        semodule -i "$module_path"
    done
}

# Install selinux policies only on the Enterprise instance
if $is_enterprise_instance; then
    install_semodules
fi
sed -i "s/FortiSOAR Version:.*/FortiSOAR Version: $version-$build_number/g" /etc/motd > /dev/null 2>&1
chmod a+x /opt/cyops/scripts/confUtil.py
