#!/bin/sh
# Copyright start
# Copyright (C) 2008 - 2025 Fortinet Inc.
# All rights reserved.
# FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE
# Copyright end

set -x

name='cyops-integrations'
prefix=/opt/$name
user_integrations=fsr-integrations

pip_conf="$prefix/.env/pip.conf"
chattr -i $pip_conf
if ! grep -q "prefix=" "$pip_conf"; then
    echo "prefix=/opt/cyops/configs/integrations/packages" >> $pip_conf
    cat /opt/cyops-integrations/.env/pip.conf
fi
chattr +i $pip_conf
pth_file="$prefix/.env/lib/python3.9/site-packages/custom-fortisoar-packages-paths.pth"
if [ ! -f "$pth_file" ]; then
    echo "/opt/cyops/configs/integrations/packages/lib/python3.9/site-packages" > $pth_file
    chmod 644 $pth_file
    chown $user_integrations:$user_integrations $pth_file
fi
restorecon -R $prefix

### Post-upgrade Actions

### Common Actions
ln -sf /etc/pki/cyops/integrationspublic.key $prefix/integrations/configs/
ln -sf /etc/pki/cyops/integrationsprivate.key $prefix/integrations/configs/

# lsof path broken for connectors https://bugzilla.redhat.com/show_bug.cgi?id=1260300
ln -sf /usr/bin/lsof /usr/sbin/lsof

# Below script configures fsr-integrations user for integrations.
# Below script stop and start the uWSGI service
$prefix/package/setup.sh

# Migrate database
cd $prefix/integrations
sudo -u $user_integrations $prefix/.env/bin/python3 manage.py migrate >/dev/null
sudo -u $user_integrations $prefix/.env/bin/python3 manage.py encrypt_connector_passwords >/dev/null 
restorecon -R $prefix
restorecon -R /etc/
systemctl start nginx

# Populating connectors
#sudo -u $user_integrations $prefix/.env/bin/python3 manage.py connectors >/dev/null

# Populating Annotations
sudo -u $user_integrations $prefix/.env/bin/python3 manage.py loadannotation

# create cache table
sudo -u $user_integrations $prefix/.env/bin/python3 manage.py createcachetable

# Set selinux user system_u
semanage fcontext -a -s system_u -t var_log_t "/var/log/cyops/cyops-integrations" 2>/dev/null
restorecon -rvF /var/log/cyops/cyops-integrations
