#!/bin/sh
# Copyright start
# Copyright (C) 2008 - 2025 Fortinet Inc.
# All rights reserved.
# FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE
# Copyright end

set -x

store_to_json(){
    # This method can be used to store data in step_result.json
    # $1 is target fsr version which is passed to this file during execution. Pass $1 as it is as first argument while calling this function
    # $2 is to take phase_name
    # $3 is to take task_name
    # $4 is to take key for data to store in json
    # $5 is to take data to store in json
    json_file_path="/opt/fsr-elevate/elevate/outputs/step_result-$1.json"
    python3 -c "import sys; sys.path.append('/opt/fsr-elevate/elevate'); from framework.utility.task_utils import TaskUtilities; task_utils=TaskUtilities(); task_utils.store_result_to_json(\"$json_file_path\",\"$2\",\"$3\",\"$4\",\"$5\")"
}

get_data_from_json(){
    # This method can be used to get data from step_result.json
    # $1 is target fsr version which is passed to this file during execution. Pass $1 as it is as first argument while calling this function
    # $2 is to take phase_name
    # $3 is to take task_name
    # $4 is to take key in which data is stored
    target_version=$1
    
    json_file_path="/opt/fsr-elevate/elevate/outputs/step_result-$target_version.json"
    if [ $# = 1 ];then
        result=$(jq -r "" "$json_file_path")
    elif [ $# = 2 ];then
        key1=$2
        result=$(jq -r --arg key1 "$key1" '.[$key1]' "$json_file_path")
    elif [ $# = 3 ];then
        key1=$2
        key2=$3
        result=$(jq -r --arg key1 "$key1" --arg key2 "$key2" '.[$key1][$key2]' "$json_file_path")
    elif [ $# = 4 ];then
        key1=$2
        key2=$3
        key3=$4
        result=$(jq -r --arg key1 "$key1" --arg key2 "$key2" --arg key3 "$key3" '.[$key1][$key2][$key3]' "$json_file_path")
    else 
        result="Filter upto 3 level is supported. Provided more than 3 filter parameters in '$0'"
    fi
    if [ "${result}" = "null" ];then echo "Please provide valid filter key in '$0'."
    else echo "$result"
    fi
}

version=$1
build_number=$(get_data_from_json "$1" 'upgrade' 'upgrade' 'build_number')
s_yum_repo=$(get_data_from_json "$1" 'pre-upgrade' 'initialize' 's_yum_repo')

### Post-upgrade Actions

### Common Actions
add_perm_sudoers() {
    SUDOERS='/etc/sudoers'

    # During join-cluster via API, we start,stop,status the services using csadm also import the log forwarding
    # configuration.
    # While setting the proxy via UI, we use csadm network *
    # For connector installation in HA, we use /bin/yum.
    # Das installs ui license through CLI
    # Das installs extension license through CLI.
    # 'csadm mq client-certs generate' gets used on FortiCloud to generate the client cert automatically
    # when adding the agent/tenant.

    nginx_sudoers="nginx ALL=(ALL) NOPASSWD: /bin/hamanager, /bin/csadm services *, /bin/csadm log forward import-config *, /bin/csadm network *, /bin/csadm license *, /bin/csadm package *, /opt/cyops-auth/utilities/licensemanager.py --deploy-extension-license, /bin/csadm log --collect *, /bin/csadm mq client-certs generate *"

    # following call will be run for fresh install and upgrade as well

    if grep -qE "^\s*nginx\s+ALL\s*=\s*\(\s*ALL\s*\)\s+NOPASSWD\s*:\s*.*csadm\s*log" $SUDOERS; then
        # replace old line
        nginx_sudoers=$(echo "$nginx_sudoers" | sed  -e 's:/:\\\/:g')
        sed -i "s/^\s*nginx \+ALL *= *( *ALL *) *NOPASSWD *: *.*csadm *log.*$/$nginx_sudoers/g" $SUDOERS
    else
        echo "$nginx_sudoers" >> $SUDOERS
    fi

    # Delete the group permissions added for nginx user. This is required for legacy releases
    # before 6.4.4

    sed -i "/^\s*\%nginx \+ALL *= *NOPASSWD/d" $SUDOERS
}

configure_sudoers_exclude_logging() {
    SUDOERS='/etc/sudoers'

    #
    # Delete below line for legacy releases. This is required for legacy releases
    # before 6.4.4
    #

    sed -i "/^\s*Cmnd_Alias \+HAMANAGER/d" $SUDOERS
    sed -i "/^\s*Defaults!HAMANAGER/d" $SUDOERS

    sed -i "/^\s*Cmnd_Alias \+HA_NOTIFICATIONS_USING_EXECUTE_ACTION/d" $SUDOERS
    sed -i "/^\s*Defaults!HA_NOTIFICATIONS_USING_EXECUTE_ACTION/d" $SUDOERS

    #
    # HA notifications, defaults after 5 mins sends the notification using integration management
    # command which we run using sudo. When we run using sudo, OS logs it to
    # /var/log/messages and /var/log/secure. To avoid logging, we need below rule.
    #

    alias_exclude_log_list="Cmnd_Alias ALIAS_EXCLUDE_LOG_LIST = /bin/hamanager, /opt/cyops-integrations/.env/bin/python3 /opt/cyops-integrations/integrations/manage.py execute_action *, /bin/php /opt/cyops-api/bin/console app\:logout\:token *"

    if grep -qE "^\s*Cmnd_Alias\s+ALIAS_EXCLUDE_LOG_LIST" $SUDOERS; then
        # replace old line
        alias_exclude_log_list=$(echo "$alias_exclude_log_list" | sed -e 's#\\#\\\\#g')
        alias_exclude_log_list=$(echo "$alias_exclude_log_list" | sed -e 's:/:\\\/:g')
        sed -i "s/^\s*Cmnd_Alias \+ALIAS_EXCLUDE_LOG_LIST *=.*$/$alias_exclude_log_list/g" $SUDOERS
    else
        echo "$alias_exclude_log_list" >> $SUDOERS
    fi

    if grep -qE "^\s*Defaults!ALIAS_EXCLUDE_LOG_LIST" $SUDOERS; then
        sed -i "s/Defaults!ALIAS_EXCLUDE_LOG_LIST.*$/Defaults!ALIAS_EXCLUDE_LOG_LIST !syslog/g" $SUDOERS
    else
        echo "Defaults!ALIAS_EXCLUDE_LOG_LIST !syslog" >> $SUDOERS
    fi
}

set_flags_dir() {
    # flags dir have permission as 755. This means no other user can
    # can write to this dir. In below cmds, we are allowing specfic users
    # to read/write/execute from this dir. Please note that, we even if user
    # have write permission, it can not delete the files created by other user
    # as we have sticky bit set on this dir.
    #
    flags_dir="/opt/cyops/configs/.flags/"
    allowed_users="nginx tomcat"
    for user in $allowed_users; do
        setfacl -m u:"$user":rwx $flags_dir
    done
}

# Update /etc/environment with new repo name
f_etc_env="/etc/environment"
grep -q "$s_yum_repo" $f_etc_env
if [ $? -eq 1 ];then
    sed -i "s/product_yum_server=.*$/product_yum_server=$s_yum_repo/g" $f_etc_env
fi

echo "{\"version\": \"$version-$build_number\"}" > /opt/cyops-ui/cyops_version.json
add_perm_sudoers
configure_sudoers_exclude_logging
set_flags_dir

# Run logrotate every two minutes
f_cron_root="/var/spool/cron/root"
if [ -f "$f_cron_root" ];then
    if ! grep -q  "%{f_logrotate_cyops}" $f_cron_root; then
        echo "Updating $f_cron_root"
        sudo echo "0 0 * * * /sbin/logrotate  -f %{f_logrotate_cyops}" >> $f_cron_root
    fi
else
    echo "Creating $f_cron_root"
    sudo echo "0 0 * * * /sbin/logrotate  -f %{f_logrotate_cyops}" >> $f_cron_root
fi

# Cleanup any existing metadata_expire values present in /etc/yum.conf
sed --in-place --follow-symlinks '/metadata_expire=/d' /etc/yum.conf

# Doing this will not require user to run yum clean all before running yum command
echo "metadata_expire=1800s" >> /etc/yum.conf

# Grant write permission to /var/log/cyops
chmod -R +w /var/log/cyops

# Start chronyd
systemctl enable chronyd
systemctl start chronyd

# Set nginx user ownership on dir /var/cache/nginx
# Originally it has root ownership due to which nginx process cannot perform
# the write operation and then product does not work
if [ -d "/var/cache/nginx" ];then
    chown -R nginx: /var/cache/nginx
fi

# Need to use UTC for RTC
/bin/timedatectl set-local-rtc 0
systemctl enable nginx
systemctl start nginx

# Postfix is required for sending emails using smtp connector from localhost
systemctl enable postfix.service
systemctl start postfix.service