""" Copyright start
  Copyright (C) 2008 - 2025 Fortinet Inc.
  All rights reserved.
  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE
  Copyright end """
"""
Django settings for connector project.

Generated by 'django-admin startproject' using Django 1.8.4.

For more information on this file, see
https://docs.djangoproject.com/en/1.8/topics/settings/

For the full list of settings and their values, see
https://docs.djangoproject.com/en/1.8/ref/settings/
"""

import os
from configparser import RawConfigParser
# Import some utility functions
from os.path import abspath, basename, dirname, join
from concurrent.futures import ThreadPoolExecutor
from os import environ
import itertools
from integrations.password_utils import *
from utils.config_parser import all_config

# reading name value pairs of environment variables from /etc/environment
# change the filename if you want to import a restricted set of variables
# for restricting system access

filename = '/etc/environment'
env_config = RawConfigParser()
try:
    with open(filename) as fp:
        env_config.read_file(itertools.chain(['[environment]'], fp), source=filename)
    for key, value in env_config.items('environment'):
        value = value.lstrip("'").rstrip("'")
        value = value.lstrip('"').rstrip('"')
        environ.setdefault(key, value)
except:
    # error parsing environment file
    pass

ALL_CONFIG = all_config
# ##### PATH CONFIGURATION ################################
# Fetch Django's project directory
DJANGO_ROOT = dirname(dirname(abspath(__file__)))
BASE_DIR = os.path.dirname(os.path.dirname(os.path.abspath(__file__)))

# Fetch the project_root
PROJECT_ROOT = dirname(DJANGO_ROOT)

# The name of the whole site
SITE_NAME = basename(DJANGO_ROOT)

# Load configurations
CONFIG_DIR = join(DJANGO_ROOT, 'configs')
CONFIG_FILE = 'config.ini'
application_config = RawConfigParser()
application_config.read(join(CONFIG_DIR, CONFIG_FILE))

APPLICATION_CONFIG = application_config

# RabbitMQ Publisher
CONNECTION_RETRY_COUNT = 3
CONNECTION_RETRY_DELAY = 5
PUBLISH_MESSAGE_RETRY_COUNT = 5

# ##### APPLICATION CONFIGURATION #########################
DJANGO_APPS = [
    'django.contrib.admin',
    'django.contrib.auth',
    'django.contrib.contenttypes',
    'django.contrib.sessions',
    'django.contrib.messages',
    'django.contrib.staticfiles',
    'django_filters',
    'rest_framework',
]

THIRD_PARTY_APPS = [
    # 'corsheaders',
]

CONNECTOR_APPS = [
    'postman',
    'connectors',
    'annotation',
    'data_import',
    'replay'
]

# See: https://docs.djangoproject.com/en/dev/ref/settings/#installed-apps
INSTALLED_APPS = DJANGO_APPS + THIRD_PARTY_APPS + CONNECTOR_APPS

# Middlewares
MIDDLEWARE = [
    'django.contrib.sessions.middleware.SessionMiddleware',
    'django.middleware.common.CommonMiddleware',
    'django.middleware.csrf.CsrfViewMiddleware',
    'django.contrib.auth.middleware.AuthenticationMiddleware',
    'django.contrib.messages.middleware.MessageMiddleware',
    'django.middleware.clickjacking.XFrameOptionsMiddleware',
]

# Hosts/domain names that are valid for this site; required if DEBUG is False
# See https://docs.djangoproject.com/en/1.5/ref/settings/#allowed-hosts
ALLOWED_HOSTS = ['localhost', '127.0.0.1']

# Connector settings
CONNECTORS_DIR = join(DJANGO_ROOT, 'connectors')
CONNECTORS_EXTENSION = '.tgz'
CONNECTOR_DEVELOPMENT_VERSION_POSTFIX = '_dev'
CONNECTORS_RESERVED = ('core', 'cyops_utilities', 'file_operations', 'database', 'imap', 'smtp', 'irc', 'soap', 'ssh', 'code-snippet', 'cyops-schedule-report', 'cyops-system-monitoring', 'bpmn-to-playbooks', 'fortisoar-ml-engine', 'phishing-classifier', 'fsr-agent-communication-bridge')


WEB_ROOT = os.path.join(os.path.dirname(BASE_DIR), 'web/')
STATIC_URL = '/integration/static/'
STATIC_ROOT = join(WEB_ROOT, 'static/')

# ##### DATABASE CONFIGURATION ############################
DB_HOST = ALL_CONFIG.config.get('postgres.pg_host')
DB_PORT = ALL_CONFIG.config.get('postgres.pg_port', '5432')
DB_NAME = application_config.get('database', 'db_name')
DB_USER = ALL_CONFIG.config.get('postgres.pg_user')
DB_PASSWORD = manage_password(ALL_CONFIG.config.get('postgres.pg_password'), 'decrypt')

DATABASES = {
    'default': {
        'ENGINE': 'django.db.backends.postgresql_psycopg2',
        'USER': DB_USER,
        'PASSWORD': DB_PASSWORD,
        'NAME': DB_NAME,
        'HOST': DB_HOST,
        'PORT': DB_PORT,
        'OPTIONS': {
            'client_encoding': 'UTF-8'
        }

    }
}

# ##### SECURITY CONFIGURATION ############################
SECRET_KEY = '1qsjrdu6005n=^ukpx=&_scsrf%28)4xvbo%904-8+@him6$hp'

# ##### DJANGO RUNNING CONFIGURATION ######################
# The default WSGI application
WSGI_APPLICATION = '%s.wsgi.application' % SITE_NAME

# The root URL configuration
ROOT_URLCONF = '%s.urls' % SITE_NAME

TEMPLATES = [
    {
        'NAME': 'django',
        'BACKEND': 'django.template.backends.django.DjangoTemplates',
        'DIRS': [],
        'APP_DIRS': True,
        'OPTIONS': {
            'context_processors': [
                'django.template.context_processors.debug',
                'django.template.context_processors.request',
                'django.contrib.auth.context_processors.auth',
                'django.contrib.messages.context_processors.messages',
            ],
        },
    },
    {
        'NAME': 'jinja2',
        'BACKEND': 'django.template.backends.jinja2.Jinja2',
        'DIRS': [],
        'APP_DIRS': False,
        'OPTIONS': {
            'environment': 'integrations.jinja.environment'
        }
    },
]

REST_FRAMEWORK = {
    'DEFAULT_PAGINATION_CLASS': 'connectors.pagination.ConnectorPageNumberPagination',
    'PAGE_SIZE': 30,
    'DEFAULT_PARSER_CLASSES': (
        'rest_framework.parsers.JSONParser',
    ),
    'DEFAULT_AUTHENTICATION_CLASSES': [
        'rest_framework.authentication.SessionAuthentication',
    ]
}

CACHES = {
    'default': {
        'BACKEND': 'django.core.cache.backends.db.DatabaseCache',
        'LOCATION': 'integrations_cache',
    }
}

# This site's ID
SITE_ID = 1

# ##### INTERNATIONALIZATION ##############################
LANGUAGE_CODE = 'en-us'

TIME_ZONE = 'UTC'

# Internationalization
USE_I18N = True

# Localization
USE_L10N = True

# enable time zone awareness by default
USE_TZ = True

# Static files (CSS, JavaScript, Images)
# https://docs.djangoproject.com/en/1.9/howto/static-files/
STATIC_URL = '/static/'
STATIC_ROOT = join(DJANGO_ROOT, 'static/')

TMP_FILE_ROOT = '/tmp/'

# DEBUG
DEBUG = False
if application_config.getboolean('application', 'debug'):
    DEBUG = True

# ##### LOGGING ##############################
APP_LOG_FILE_PATH = application_config.get('logging', 'app_log_file_path')
APP_LOG_FILE_SIZE = eval(application_config.get('logging', 'app_log_file_size'))
APP_LOG_FILE_BACKUP_COUNT = eval(application_config.get('logging', 'app_log_file_backup_count'))

CONNECTOR_LOGGER_LEVEL = application_config.get('logging', 'connector_logger_level')
DJANGO_LOGGER_LEVEL = application_config.get('logging', 'django_logger_level')

ROUTER_HEARTBEAT = int(application_config.get('router', 'heartbeat', fallback='120'))
ROUTER_CONNECTION_ATTEMPTS = int(application_config.get('router', 'connection_attempts', fallback='5'))
ROUTER_RETRY_DELAY = int(application_config.get('router', 'retry_delay', fallback='10'))
CONNECTOR_CACHE_DELAY = int(application_config.get('connector_configuration', 'retry_delay', fallback='5'))
SELF_ID = None
MASTER_ID = None
LW_AGENT = True
THREAD_POOL_WORKER = eval(application_config.get('application', 'THREAD_POOL_WORKER', fallback='16'))

LOGGING = {
    'version': 1,
    'disable_existing_loggers': True,
    'formatters': {
        'verbose': {
            'format': '[%(asctime)s] %(levelname)s %(name)s %(module)s %(funcName)s(): %(message)s',
            'datefmt': '%Y-%m-%d %H:%M:%S'
        }
    },
    'handlers': {
        'app_logger': {
            'class': 'logging.handlers.RotatingFileHandler',
            'filename': APP_LOG_FILE_PATH,
            'maxBytes': APP_LOG_FILE_SIZE,
            'backupCount': APP_LOG_FILE_BACKUP_COUNT,
            'formatter': 'verbose'
        }
    },
    'loggers': {
        'connectors': {
            'handlers': ['app_logger'],
            'level': CONNECTOR_LOGGER_LEVEL,
            'propagate': False
        },
        'annotation': {
            'handlers': ['app_logger'],
            'level': CONNECTOR_LOGGER_LEVEL,
            'propagate': False
        },
        'django.request': {
            'handlers': ['app_logger'],
            'level': DJANGO_LOGGER_LEVEL,
            'propagate': False
        },
        'postman': {
            'handlers': ['app_logger'],
            'level': CONNECTOR_LOGGER_LEVEL,
            'propagate': False
        },
        'replay': {
            'handlers': ['app_logger'],
            'level': CONNECTOR_LOGGER_LEVEL,
            'propagate': False
        },
        'pika': {
            'handlers': ['app_logger'],
            'level': CONNECTOR_LOGGER_LEVEL,
            'propagate': False
        },
    }
}

CH_MAX_RETRY_COUNT = 10
CH_RETRY_SLEEP = 10

CONNECTORS_JSON = {}
CONNECTOR_TEMPLATES = []
CONNECTORS_REPO_NAMES = []
PRODUCT_YUM_SERVER = os.getenv('product_yum_server', 'repo.fortisoar.fortinet.com')
CONN_RPM_TEMP_DIR = application_config.get('application', 'conn_rpm_temp_dir',
                                           fallback='/opt/cyops-integrations/cyops_connector_rpm')

SDK_PORT = '8999'
RELEASE_VERSION = '6.4.3'
CH_API_REQUEST = {}

CRUD_HUB_URL = 'https://' + application_config.get('application', 'app_host')

THREAD_POOL_EXECUTOR = ThreadPoolExecutor(max_workers=THREAD_POOL_WORKER)

# Setting it to 1 to ensure main process is free.
# Issue Recognized with VT Connector calling on add Config
# To Fetch data from Master
THREAD_POOL_INSTRUCTION_EXECUTOR = ThreadPoolExecutor(max_workers=1)

FSR_NODE = '/api/3/picklists/5de19a34-1d8b-4423-91fc-4c243a5b62fd'
FSR_AGENT = '/api/3/picklists/502cb999-d0fe-466f-9d99-1f3300513e14'
ENABLE_REMOTE_CONNECTOR_OPERATION = application_config.getboolean('application', 'ENABLE_REMOTE_CONNECTOR_OPERATION',
                                                                  fallback=True)
EXCLUDE_EXTENSIONS = eval(application_config.get('application', 'EXCLUDE_EXTENSIONS',  fallback='None'))
REPLICATING_LOG = {}
LOG_PAGINATION = 100
MAX_RECORD_LIMIT = '500'
DEFAULT_AUTO_FIELD = 'django.db.models.AutoField'

BLOCK_IN_TEMPLATE = ['__class__', '__base__', '__subclass__', '__builtins__', '__import__', '__globals__', '__init__']

CONNECTOR_INSTALLATION_DIR = '/opt/cyops/configs/integrations/connectors/'
DEV_CONNECTOR_INSTALLATION_DIR = '/opt/cyops/configs/integrations/connectors_development/'

# HA Information
IS_ACTIVE_PRIMARY = True
NODE_ID = ''
FIELDS_TO_IGNORE_FROM_INFO_JSON = ['agent', 'status', 'install_result', 'config_count', 'ingestion_supported',
                                   'cs_approved', 'tags', 'remote_status', 'rpm_full_name', 'installed', 'created',
                                   'modified', 'requirements_installed', 'forked_from', 'rpm_installed',
                                   'is_contain_function', 'is_contain_function_ref', 'help_file']


TIME_SLEEP_BETWEEN_SYNC_MQ_CALL = 2
