""" Copyright start
  Copyright (C) 2008 - 2021 Fortinet Inc.
  All rights reserved.
  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE
  Copyright end """
import logging
from fsr_utilities.broker_core.rmq_broker import Rmq
from fsr_utilities.broker_core.kafka_broker import Kafka

logger = logging.getLogger(__name__)


# A factory to instantiate the correct broker object
class BrokerFactory:
    @staticmethod
    # Broker can be determined from settings also
    def get_broker_instance(config, broker='rmq'):
        if broker == 'rmq':
            return Rmq(config)
        if broker == 'kafka':
            return Kafka(config)
