""" Copyright start
  Copyright (C) 2008 - 2021 Fortinet Inc.
  All rights reserved.
  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE
  Copyright end """
import logging
logger = logging.getLogger(__name__)

CONF_FILE = '/opt/cyops/configs/rabbitmq/rabbitmq_users.conf'


def read_properties_file(properties_file_path):
    config = {}
    separators = ['=', ':', ' ']
    with open(properties_file_path, 'r') as properties_file:
        for line in properties_file:
            strip_line = line.strip()
            if strip_line.startswith('#'):
                continue
            if '#' in strip_line:
                strip_line = strip_line.split('#', 1)[0].strip()
            for separator in separators:
                if separator in strip_line:
                    key_value = strip_line.split(separator, 1)
                    key = key_value[0].strip()
                    value = key_value[1].strip()
                    config[key] = value
                    break
    return config


def _prepare_mq_config_dict():
    config = read_properties_file(CONF_FILE)
    config['userName'] = config.get('cyops.rabbitmq.user')
    config['password'] = config.get('cyops.rabbitmq.password')
    config['host'] = config.get('cyops.rabbitmq.host')
    config['port'] = config.get('cyops.rabbitmq.port')
    config['virtualHost'] = config.get('cyops.rabbitmq.vhost')
    config['ssl'] = False
    config['role'] = 'self'
    return config


def prepare_intra_cyops_config(*args, **kwargs):
    config = _prepare_mq_config_dict()
    return config
