import logging
import requests

logger = logging.getLogger(__name__)


def maybe_json_or_raise(response, *args, **kwargs):
    """
    Helper function for processing request responses

    Returns any json found in the response. Otherwise, it will extract the
    response as text, or, failing that, as bytes.

    :return: the response from the request
    :rtype: dict or str or bytes
    :raises: :class:`requests.HTTPError` if status code was 4xx or 5xx
    """
    if response.ok:
        try:
            logger.info('Processing request responses.')
            return response.json(strict=False)
        except Exception:
            logger.warning(response.text or response.content)
            return response.content
    else:
        msg = ''
        try:
            msg = response.json()
            logger.warning(msg)
        except Exception:
            pass
        if not msg:
            msg = response.text
            logger.warning(msg)
        try:
            response.raise_for_status()
        except requests.exceptions.HTTPError as e:
            # add any response content to the error message
            msg = '{} :: {}'.format(str(e), msg)
            logger.error(msg)
            raise requests.exceptions.HTTPError(msg, response=response)
