""" Copyright start
  Copyright (C) 2008 - 2025 Fortinet Inc.
  All rights reserved.
  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE
  Copyright end """
# Django WSGI application path in pattern MODULE_NAME:VARIABLE_NAME
wsgi_app = "integrations.wsgi:application"
# The granularity of Error log outputs
loglevel = "warn"
# The number of worker processes for handling requests
workers = 2
# The socket to bind
bind = "localhost:8999"
# Write access and error info to /var/log
accesslog = errorlog = "/var/log/cyops/cyops-integrations/integrations.log"
# Redirect stdout/stderr to log file
capture_output = True
# PID file so you can easily fetch process ID
pidfile = "/var/run/fsr-integrations-agent/fsr-integrations-agent.pid"
# Decrease the time for stopping the workers (Time in sec)
graceful_timeout = 5