""" Copyright start
  Copyright (C) 2008 - 2025 Fortinet Inc.
  All rights reserved.
  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE
  Copyright end """
# Generated by Django 2.2.3 on 2020-05-11 14:37

from django.db.models import JSONField
from django.db import migrations, models


class Migration(migrations.Migration):

    initial = True

    dependencies = [
    ]

    operations = [
        migrations.CreateModel(
            name='Team',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('uuid', models.CharField(max_length=100)),
            ],
        ),
        migrations.CreateModel(
            name='Tenant',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=500)),
                ('role', models.CharField(blank=True, max_length=500, null=True)),
                ('active', models.BooleanField(default=False)),
                ('tenant_id', models.CharField(max_length=1000, unique=True)),
                ('uuid', models.CharField(max_length=500, unique=True)),
                ('is_dedicated', models.BooleanField(default=False)),
            ],
        ),
        migrations.CreateModel(
            name='Agent',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=500)),
                ('agent_id', models.CharField(max_length=1000, unique=True)),
                ('active', models.BooleanField(default=False)),
                ('uuid', models.CharField(max_length=500, unique=True)),
                ('is_local', models.BooleanField(default=False)),
                ('version', models.CharField(default='6.4.0', max_length=20)),
                ('health_status', JSONField(blank=True, default=dict, null=True)),
                ('sync_time', models.DateTimeField(blank=True, null=True)),
                ('team', models.ManyToManyField(to='postman.Team')),
                ('tenant', models.ManyToManyField(to='postman.Tenant')),
                ('config_status', models.CharField(max_length=1000, blank=True, null=True)),
            ],
        ),
    ]
