""" Copyright start
  Copyright (C) 2008 - 2021 Fortinet Inc.
  All rights reserved.
  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE
  Copyright end """
import abc
import logging

logger = logging.getLogger(__name__)


class Broker(metaclass=abc.ABCMeta):
    @abc.abstractmethod
    def _create_connection(self, config):
        pass

    @abc.abstractmethod
    def publish(self, message, publish_config):
        pass

    @abc.abstractmethod
    def start_consumer(self):
        pass

    @abc.abstractmethod
    def stop_consumer(self):
        pass
