""" Copyright start
  Copyright (C) 2008 - 2025 Fortinet Inc.
  All rights reserved.
  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE
  Copyright end """
# Generated by Django 2.0.3 on 2019-03-07 08:57

from django.db.models import JSONField
from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    dependencies = [
        ('connectors', '0005_auto_20190307_0855'),
    ]

    operations = [
        migrations.CreateModel(
            name='Configuration',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('config_id', models.CharField(max_length=100, unique=True)),
                ('status', models.IntegerField(default=1)),
                ('name', models.CharField(max_length=100)),
                ('default', models.BooleanField(default=False)),
                ('config', JSONField(blank=True, default=dict, null=True)),
            ],
        ),
        migrations.CreateModel(
            name='Operation',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('operation', models.CharField(max_length=100)),
                ('description', models.CharField(blank=True, max_length=1000, null=True)),
                ('title', models.CharField(max_length=100)),
                ('output_schema', JSONField(blank=True, default=dict, null=True)),
                ('parameters', JSONField(blank=True, default=dict, null=True)),
                ('enabled', models.BooleanField(default=True)),
                ('annotation', models.CharField(blank=True, max_length=100, null=True)),
                ('metadata', JSONField(blank=True, default=dict, null=True)),
            ],
        ),
        migrations.AddField(
            model_name='connector',
            name='config_schema',
            field=JSONField(blank=True, default=dict, null=True),
        ),
        migrations.AddField(
            model_name='connector',
            name='cs_compatible',
            field=models.BooleanField(default=True),
        ),
        migrations.AddField(
            model_name='connector',
            name='migrate',
            field=models.BooleanField(default=False),
        ),
        migrations.AddField(
            model_name='connector',
            name='description',
            field=models.TextField(blank=True, null=True),
        ),
        migrations.AddField(
            model_name='connector',
            name='help_file',
            field=models.TextField(blank=True, null=True),
        ),
        migrations.AddField(
            model_name='connector',
            name='help_online',
            field=models.TextField(blank=True, null=True),
        ),
        migrations.AddField(
            model_name='connector',
            name='metadata',
            field=JSONField(blank=True, default=dict, null=True),
        ),
        migrations.AddField(
            model_name='connector',
            name='publisher',
            field=models.CharField(blank=True, max_length=500, null=True),
        ),
        migrations.AddField(
            model_name='connector',
            name='status',
            field=models.CharField(blank=True, max_length=50, null=True),
        ),
        migrations.AddField(
            model_name='connector',
            name='install_result',
            field=JSONField(blank=True, default=dict, null=True),
        ),
        migrations.AddField(
            model_name='connector',
            name='vendor_version',
            field=models.TextField(blank=True, null=True),
        ),
        migrations.AddField(
            model_name='connector',
            name='config_count',
            field=models.IntegerField(default=0),
        ),
        migrations.AddField(
            model_name='operation',
            name='connector',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='operations', to='connectors.Connector'),
        ),
        migrations.AddField(
            model_name='configuration',
            name='connector',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='configuration', to='connectors.Connector'),
        ),
        migrations.AlterUniqueTogether(
            name='operation',
            unique_together={('operation', 'connector')},
        ),
        migrations.AlterUniqueTogether(
            name='configuration',
            unique_together={('name', 'connector')},
        ),
    ]
