""" Copyright start
  Copyright (C) 2008 - 2025 Fortinet Inc.
  All rights reserved.
  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE
  Copyright end """
# Generated by Django 2.2.3 on 2020-05-11 14:37

from django.db.models import JSONField
from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    dependencies = [
        ('postman', '0001_initial'),
        ('connectors', '0008_data_migration_for_0007'),
    ]

    operations = [
        migrations.AddField(
            model_name='configuration',
            name='agent',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='postman.Agent', to_field='agent_id'),
        ),
        migrations.AddField(
            model_name='configuration',
            name='health_status',
            field=JSONField(blank=True, default=dict, null=True),
        ),
        migrations.AddField(
            model_name='configuration',
            name='remote_status',
            field=JSONField(blank=True, default=dict, null=True),
        ),
        migrations.AddField(
            model_name='connector',
            name='agent',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='postman.Agent', to_field='agent_id'),
        ),
        migrations.AddField(
            model_name='connector',
            name='remote_status',
            field=JSONField(blank=True, default=dict, null=True),
        ),
        migrations.AddField(
            model_name='connector',
            name='rpm_full_name',
            field=models.CharField(blank=True, max_length=500, null=True),
        ),
        migrations.AlterField(
            model_name='connector',
            name='cs_approved',
            field=models.BooleanField(blank=True, default=False),
        ),
        migrations.AlterField(
            model_name='connector',
            name='ingestion_supported',
            field=models.BooleanField(blank=True, default=False),
        ),
        migrations.AlterUniqueTogether(
            name='configuration',
            unique_together={('name', 'connector', 'agent')},
        ),
        migrations.AlterUniqueTogether(
            name='connector',
            unique_together={('name', 'version', 'agent')},
        ),
        migrations.CreateModel(
            name='ExecuteAction',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('result', JSONField(blank=True, default=dict, null=True)),
                ('action', models.CharField(max_length=500)),
                ('remote_status', JSONField(blank=True, default=dict, null=True)),
                ('request_payload', JSONField(blank=True, default=dict, null=True)),
                ('created', models.DateTimeField(auto_now_add=True)),
                ('modified', models.DateTimeField(auto_now=True)),
                ('log_records', models.TextField(blank=True, null=True)),
                ('agent', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='postman.Agent', to_field='agent_id')),
                ('configuration', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='connectors.Configuration', to_field='config_id')),
                ('connector', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='connectors.Connector')),
            ],
        ),
    ]
